/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import java.util.List;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrix3x3;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.fixed.CommonOps_DDF3;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.ejml.ops.ConvertDMatrixStruct;

public class AverageRotationMatrix_F64 {
    DMatrixRMaj M = new DMatrixRMaj(3, 3);
    DMatrix3x3 F = new DMatrix3x3();
    SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd((int)3, (int)3, (boolean)true, (boolean)true, (boolean)true);

    public boolean process(List<DMatrixRMaj> list, DMatrixRMaj average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        this.M.zero();
        for (int i = 0; i < list.size(); ++i) {
            DMatrixRMaj m = list.get(i);
            this.M.data[0] = this.M.data[0] + m.data[0];
            this.M.data[1] = this.M.data[1] + m.data[1];
            this.M.data[2] = this.M.data[2] + m.data[2];
            this.M.data[3] = this.M.data[3] + m.data[3];
            this.M.data[4] = this.M.data[4] + m.data[4];
            this.M.data[5] = this.M.data[5] + m.data[5];
            this.M.data[6] = this.M.data[6] + m.data[6];
            this.M.data[7] = this.M.data[7] + m.data[7];
            this.M.data[8] = this.M.data[8] + m.data[8];
        }
        CommonOps_DDRM.divide((DMatrixD1)this.M, (double)list.size());
        if (!this.svd.decompose((Matrix)this.M)) {
            return false;
        }
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)this.svd.getU(null, false)), (DMatrix1Row)((DMatrix1Row)this.svd.getV(null, false)), (DMatrix1Row)average);
        double det = CommonOps_DDRM.det((DMatrixRMaj)average);
        if (det < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)average);
        }
        return true;
    }

    public boolean process(List<DMatrix3x3> list, DMatrix3x3 average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        CommonOps_DDF3.fill((DMatrix3x3)this.F, (double)0.0);
        for (int i = 0; i < list.size(); ++i) {
            DMatrix3x3 m = list.get(i);
            this.F.a11 += m.a11;
            this.F.a12 += m.a12;
            this.F.a13 += m.a13;
            this.F.a21 += m.a21;
            this.F.a22 += m.a22;
            this.F.a23 += m.a23;
            this.F.a31 += m.a31;
            this.F.a32 += m.a32;
            this.F.a33 += m.a33;
        }
        CommonOps_DDF3.divide((DMatrix3x3)this.F, (double)list.size());
        ConvertDMatrixStruct.convert((DMatrix3x3)this.F, (DMatrixRMaj)this.M);
        if (!this.svd.decompose((Matrix)this.M)) {
            return false;
        }
        CommonOps_DDRM.multTransB((DMatrix1Row)((DMatrix1Row)this.svd.getU(null, false)), (DMatrix1Row)((DMatrix1Row)this.svd.getV(null, false)), (DMatrix1Row)this.M);
        double det = CommonOps_DDRM.det((DMatrixRMaj)this.M);
        if (det < 0.0) {
            CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.M);
        }
        ConvertDMatrixStruct.convert((DMatrixRMaj)this.M, (DMatrix3x3)average);
        return true;
    }
}

