/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.IDeviceContext;
import in.gov.uidai.ec.biometrics.device.IDeviceLifeCycleListener;
import in.gov.uidai.ec.biometrics.device.impl.DMConnection;
import in.gov.uidai.ec.biometrics.device.impl.DeviceContext;
import in.gov.uidai.ec.biometrics.device.impl.DeviceRegistry;
import in.gov.uidai.ec.biometrics.device.impl.IClientDeviceManagerPreference;
import in.gov.uidai.ec.biometrics.device.impl.IDMConnectionCallback;
import in.gov.uidai.ec.biometrics.device.impl.VDMConnection;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ClientDeviceManager
implements IClientDeviceManager,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDeviceManager.class);
    private static final Marker AUDIT = MarkerFactory.getMarker((String)ClientDeviceManager.class.getName());
    private IClientDeviceManagerPreference cdmPref;
    private List<IDeviceLifeCycleListener> listeners = new ArrayList<IDeviceLifeCycleListener>();
    private DMConnection dmConnection;
    private Timer dmTimer;
    private RegisteredDeviceManager registeredDeviceManager;
    private DeviceRegistry devReg = new DeviceRegistry();

    public void setPreference(IClientDeviceManagerPreference pref) {
        this.cdmPref = pref;
    }

    public void setRegisteredDeviceManager(RegisteredDeviceManager registeredDeviceManager) {
        this.registeredDeviceManager = registeredDeviceManager;
    }

    @Override
    public RegisteredDeviceManager getRegisteredDeviceManager() {
        return this.registeredDeviceManager;
    }

    public void afterPropertiesSet() {
        this.dmTimer = new Timer(true);
        this.dmTimer.schedule((TimerTask)new AutoConnectTask(), 0L);
    }

    public void destroy() {
        if (this.dmTimer != null) {
            this.dmTimer.cancel();
            this.dmTimer = null;
            LOGGER.debug("dmTimer shutdown");
        }
    }

    @Override
    public void addLifeCycleListener(IDeviceLifeCycleListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeLifeCycleListener(IDeviceLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public IDeviceContext getDeviceContext(DeviceType type) {
        VDMConnection conn = this.devReg.getConnection(type);
        DeviceInfo dinfo = this.devReg.getDeviceInfo(type);
        if (conn != null && dinfo != null) {
            return new DeviceContext(conn, dinfo);
        }
        return null;
    }

    @Override
    public void refreshDeviceStates() {
        if (this.dmConnection != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("refreshing device states");
            }
            this.dmConnection.doRetrieveRunningDevices();
            this.getRegisteredDeviceManager().refreshDeviceList();
        }
    }

    private void connectToDM() {
        if (this.dmConnection != null && this.dmConnection.isValid()) {
            return;
        }
        if (this.dmConnection != null) {
            this.dmConnection.doClose();
            this.dmConnection = null;
        }
        String dmHost = this.cdmPref.getHost();
        int minPort = this.cdmPref.getMinPortRange();
        int maxPort = this.cdmPref.getMaxPortRange();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Polling for DM on " + dmHost + " port range " + minPort + " to " + maxPort);
        }
        for (int i = minPort; i <= maxPort; ++i) {
            DMConnection conn = new DMConnection(dmHost, i);
            if (!conn.isValid()) continue;
            conn.doConnect();
            if (!conn.isValid()) {
                conn.doClose();
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("found connection on port " + i);
            }
            this.dmConnection = conn;
            break;
        }
        if (this.dmConnection == null) {
            this.dmTimer.schedule((TimerTask)new AutoConnectTask(), this.cdmPref.getAutoconnectDelay(10000L));
        } else {
            LOGGER.info(AUDIT, "connected with dm");
            this.dmConnection.setCallback(new DMConnectionCallback());
            this.refreshDeviceStates();
        }
    }

    private void fireDeviceArrived(DeviceType devType) {
        for (IDeviceLifeCycleListener listener : this.listeners) {
            try {
                listener.deviceStarted(devType);
            }
            catch (Exception exception) {}
        }
    }

    private void fireDeviceRemoved(DeviceType devType) {
        for (IDeviceLifeCycleListener listener : this.listeners) {
            try {
                listener.deviceStopped(devType);
            }
            catch (Exception exep) {
                LOGGER.warn("unable to propagate device stopped", (Throwable)exep);
            }
        }
    }

    private class DMConnectionCallback
    implements IDMConnectionCallback {
        private DMConnectionCallback() {
        }

        @Override
        public void connectionClosed() {
            ClientDeviceManager.this.dmTimer.schedule((TimerTask)new AutoConnectTask(), 0L);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("autoconnect task scheduled");
            }
        }

        @Override
        public void deviceArrived(String devUri, DeviceType devType, DeviceInfo devInfo) {
            LOGGER.info("device arrived: [" + (Object)((Object)devType) + "] " + devUri);
            ClientDeviceManager.this.devReg.addDevice(devUri, devType, devInfo);
            ClientDeviceManager.this.fireDeviceArrived(devType);
        }

        @Override
        public void deviceRemoved(String devUri) {
            LOGGER.info("device removed: " + devUri);
            DeviceType devType = ClientDeviceManager.this.devReg.getDeviceType(devUri);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("device type in registry is " + (Object)((Object)devType));
            }
            ClientDeviceManager.this.devReg.removeDevice(devUri);
            ClientDeviceManager.this.fireDeviceRemoved(devType);
        }
    }

    private class AutoConnectTask
    extends TimerTask {
        private AutoConnectTask() {
        }

        @Override
        public void run() {
            ClientDeviceManager.this.connectToDM();
        }
    }
}

