/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.impl.IDMConnectionCallback;
import in.gov.uidai.ec.biometrics.device.impl.IUnresolvedResponseHandler;
import in.gov.uidai.ec.biometrics.device.impl.RequestResponseSync;
import in.gov.uidai.ec.biometrics.device.impl.XMLInputReader;
import in.gov.uidai.ec.biometrics.device.xml.APP;
import in.gov.uidai.ec.biometrics.device.xml.Arrival;
import in.gov.uidai.ec.biometrics.device.xml.Capabilities;
import in.gov.uidai.ec.biometrics.device.xml.ClientCommandRequest;
import in.gov.uidai.ec.biometrics.device.xml.ClientCommandResponse;
import in.gov.uidai.ec.biometrics.device.xml.Connect;
import in.gov.uidai.ec.biometrics.device.xml.ConnectResponse;
import in.gov.uidai.ec.biometrics.device.xml.DeviceManagerEventRequest;
import in.gov.uidai.ec.biometrics.device.xml.DeviceManagerEventResponse;
import in.gov.uidai.ec.biometrics.device.xml.FrameType;
import in.gov.uidai.ec.biometrics.device.xml.Ping;
import in.gov.uidai.ec.biometrics.device.xml.Removal;
import in.gov.uidai.ec.biometrics.device.xml.ResponseConverter;
import in.gov.uidai.ec.biometrics.device.xml.Return;
import in.gov.uidai.ec.biometrics.device.xml.RunningDevicesInfo;
import in.gov.uidai.ec.biometrics.device.xml.SampleFormat;
import in.gov.uidai.ec.biometrics.device.xml.VideoFormat;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DMConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DMConnection.class);
    private static final int RESPONSE_TIMEOUT = 30000;
    private boolean validFlag = false;
    private RequestResponseSync rrs = new RequestResponseSync();
    private Thread responseThrd;
    private Timer heartBeatTimer;
    private Socket connSock;
    private InputStream sockIn;
    private OutputStream sockOut;
    private IDMConnectionCallback callback;

    public DMConnection(String host, int port) {
        IUnresolvedResponseHandler unresHndlr = this::handleUnresolvedResponse;
        this.rrs.addUnresolvedReponseHandler(unresHndlr);
        try {
            this.connSock = new Socket(host, port);
            this.connSock.setReuseAddress(true);
            this.sockIn = this.connSock.getInputStream();
            this.sockOut = this.connSock.getOutputStream();
        }
        catch (Exception exep) {
            LOGGER.debug("unable to open connection on port " + port);
            return;
        }
        LOGGER.debug("connected to DM on port " + port);
        Runnable runnable = this::responseLoop;
        this.validFlag = true;
        this.responseThrd = new Thread(runnable);
        this.responseThrd.setDaemon(true);
        this.responseThrd.start();
    }

    public void setCallback(IDMConnectionCallback cb) {
        this.callback = cb;
    }

    public void doConnect() {
        DeviceManagerEventRequest request = new DeviceManagerEventRequest();
        APP uidaiApp = new APP();
        uidaiApp.setVendor("UIDAI");
        uidaiApp.setAppVersion(ApplicationVersion.VERSION);
        uidaiApp.setAppName("AADHAAR Enrolment Client");
        Connect connect = new Connect();
        connect.setAPP(uidaiApp);
        connect.setApiVersion("1.0.0.0");
        UUID reqId = UUID.randomUUID();
        request.setRequestId(((Object)reqId).toString());
        request.setConnect(connect);
        if (!this.writeRemote(request)) {
            return;
        }
        DeviceManagerEventResponse response = (DeviceManagerEventResponse)this.rrs.waitForResponse(((Object)reqId).toString(), 30000L);
        if (response == null) {
            this.doClose();
            return;
        }
        if (!this.checkResponseReturn(response.getReturn())) {
            return;
        }
        ConnectResponse cresp = response.getConnectResponse();
        if (cresp == null) {
            LOGGER.error("Response from VDM does not have a ConnectResponse. Closing connection.");
            this.doClose();
            return;
        }
        String dmName = cresp.getDmName();
        String dmVersion = cresp.getDmVersion();
        String apiVersion = cresp.getApiVersion();
        int heartBeat = cresp.getHeartBeat();
        this.heartBeatTimer = new Timer(true);
        TimerTask heartBeatTask = new TimerTask(){

            @Override
            public void run() {
                DMConnection.this.doHeartBeat();
            }
        };
        this.heartBeatTimer.schedule(heartBeatTask, 0L, (long)(heartBeat * 500));
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Connected to DM " + dmName + ":" + dmVersion + ":" + apiVersion);
        }
    }

    public void doRetrieveRunningDevices() {
        UUID reqId = UUID.randomUUID();
        ClientCommandRequest request = new ClientCommandRequest();
        request.setRequestId(((Object)reqId).toString());
        if (!this.writeRemote(request)) {
            return;
        }
        ClientCommandResponse response = (ClientCommandResponse)this.rrs.waitForResponse(((Object)reqId).toString(), 30000L);
        if (response == null) {
            this.doClose();
            return;
        }
        LOGGER.debug("response received");
        RunningDevicesInfo rdi = response.getRunningDevicesInfo();
        if (rdi == null) {
            return;
        }
        List<Arrival> arrivalList = rdi.getArrivals();
        for (Arrival arrival : arrivalList) {
            DeviceInfo devInfo;
            DeviceType devType;
            String modality = arrival.getModality();
            String devUri = arrival.getDeviceURI();
            if (StringUtils.isBlank((String)devUri) || (devType = ResponseConverter.toDeviceType(modality)) == null || (devInfo = ResponseConverter.toDeviceInfo(arrival)) == null || this.callback == null) continue;
            this.callback.deviceArrived(devUri, devType, devInfo);
        }
    }

    public void doClose() {
        this.validFlag = false;
        if (this.responseThrd != null) {
            this.responseThrd.interrupt();
            this.responseThrd = null;
        }
        if (this.heartBeatTimer != null) {
            this.heartBeatTimer.cancel();
        }
        try {
            this.sockOut.close();
            this.sockIn.close();
            this.connSock.close();
        }
        catch (Exception e) {
            LOGGER.warn("while closing socket", (Throwable)e);
        }
        if (this.callback != null) {
            this.callback.connectionClosed();
            this.callback = null;
        }
    }

    public boolean isValid() {
        return this.validFlag;
    }

    private void responseLoop() {
        while (this.validFlag) {
            Digester digester = this.createDigester();
            try {
                digester.parse(this.sockIn);
            }
            catch (Exception e) {
                LOGGER.debug("vdm connection closed " + e.toString());
                this.doClose();
                break;
            }
        }
    }

    private boolean writeRemote(Object message) {
        try {
            Marshaller marshal = JAXBContext.newInstance((Class[])new Class[]{message.getClass()}).createMarshaller();
            marshal.setProperty("jaxb.fragment", (Object)true);
            if (LOGGER.isDebugEnabled()) {
                ByteArrayOutputStream logBuf = new ByteArrayOutputStream();
                marshal.setProperty("jaxb.formatted.output", (Object)true);
                marshal.marshal(message, (OutputStream)logBuf);
                LOGGER.debug("=== Outgoing Request Start ===");
                LOGGER.debug("\n" + logBuf.toString());
                LOGGER.debug("=== Outgoing Request End ===");
            }
            marshal.setProperty("jaxb.formatted.output", (Object)false);
            marshal.marshal(message, this.sockOut);
            this.sockOut.flush();
            LOGGER.debug("request sent");
            return true;
        }
        catch (Exception e) {
            LOGGER.warn("write to socket failed", (Throwable)e);
            this.doClose();
            return false;
        }
    }

    private boolean checkResponseReturn(Return returnObj) {
        if (returnObj == null) {
            LOGGER.error("Response from DM does not have a Return. Closing connection.");
            this.doClose();
            return false;
        }
        String retVal = returnObj.getValue();
        if (StringUtils.isBlank((String)retVal)) {
            LOGGER.error("Invalid return value");
            this.doClose();
            return false;
        }
        if (!retVal.equalsIgnoreCase("Success")) {
            LOGGER.error("DM returned: " + retVal + " Reason: " + returnObj.getFailureReason());
            this.doClose();
            return false;
        }
        return true;
    }

    private void doHeartBeat() {
        DeviceManagerEventResponse response;
        DeviceManagerEventRequest request = new DeviceManagerEventRequest();
        Ping ping = new Ping();
        ping.setVdmName("AADHAAR Enrolment Client");
        request.setPing(ping);
        UUID reqId = UUID.randomUUID();
        request.setRequestId(((Object)reqId).toString());
        if (!this.writeRemote(request)) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("heartbeat sent");
        }
        if ((response = (DeviceManagerEventResponse)this.rrs.waitForResponse(((Object)reqId).toString(), 30000L)) == null) {
            this.doClose();
            return;
        }
        if (!this.checkResponseReturn(response.getReturn())) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("heartbeat response received");
        }
    }

    private void handleUnresolvedResponse(String reqId, Object response) {
        LOGGER.debug("unresolved response id:" + reqId + " type:" + response.getClass().getName());
        if (response instanceof ClientCommandResponse) {
            ClientCommandResponse ccr = (ClientCommandResponse)response;
            RunningDevicesInfo rdi = ccr.getRunningDevicesInfo();
            if (rdi != null) {
                List<Arrival> arrivalList = rdi.getArrivals();
                for (Arrival arrival : arrivalList) {
                    DeviceInfo devInfo;
                    DeviceType devType;
                    String modality = arrival.getModality();
                    String devUri = arrival.getDeviceURI();
                    if (StringUtils.isBlank((String)devUri) || (devType = ResponseConverter.toDeviceType(modality)) == null || (devInfo = ResponseConverter.toDeviceInfo(arrival)) == null || this.callback == null) continue;
                    this.callback.deviceArrived(devUri, devType, devInfo);
                }
            }
        } else if (response instanceof DeviceManagerEventRequest) {
            DeviceManagerEventRequest dmer = (DeviceManagerEventRequest)response;
            Arrival arrival = dmer.getArrival();
            if (arrival != null) {
                String devUri = arrival.getDeviceURI();
                String modality = arrival.getModality();
                DeviceType devType = ResponseConverter.toDeviceType(modality);
                DeviceInfo devInfo = ResponseConverter.toDeviceInfo(arrival);
                if (StringUtils.isNotBlank((String)devUri) && devType != null && devInfo != null && this.callback != null) {
                    this.callback.deviceArrived(devUri, devType, devInfo);
                }
            } else if (dmer.getRemoval() != null) {
                String devUri = dmer.getRemoval().getDeviceURI();
                if (this.callback != null) {
                    this.callback.deviceRemoved(devUri);
                }
            }
        }
    }

    private Digester createDigester() {
        XMLInputReader digester = new XMLInputReader();
        digester.setRequestResponseSync(this.rrs);
        digester.addBoundaryTag("DeviceManagerEventRequest");
        digester.addBoundaryTag("DeviceManagerEventResponse");
        digester.addBoundaryTag("ClientCommandResponse");
        digester.addObjectCreate("DeviceManagerEventRequest", DeviceManagerEventRequest.class);
        digester.addSetProperties("DeviceManagerEventRequest");
        digester.addObjectCreate("DeviceManagerEventRequest/Arrival", Arrival.class);
        digester.addSetProperties("DeviceManagerEventRequest/Arrival");
        digester.addSetNext("DeviceManagerEventRequest/Arrival", "setArrival");
        digester.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities", Capabilities.class);
        digester.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities");
        digester.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities", "setCapabilities");
        digester.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat", VideoFormat.class);
        digester.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat");
        digester.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat", "addVideoFormat");
        digester.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType", FrameType.class);
        digester.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType");
        digester.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType", "setFrameType");
        digester.addObjectCreate("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats/SampleFormat", SampleFormat.class);
        digester.addSetProperties("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats/SampleFormat");
        digester.addSetNext("DeviceManagerEventRequest/Arrival/Capabilities/SampleFormats/SampleFormat", "addSampleFormat");
        digester.addObjectCreate("DeviceManagerEventRequest/Removal", Removal.class);
        digester.addSetProperties("DeviceManagerEventRequest/Removal");
        digester.addSetNext("DeviceManagerEventRequest/Removal", "setRemoval");
        digester.addObjectCreate("DeviceManagerEventResponse", DeviceManagerEventResponse.class);
        digester.addSetProperties("DeviceManagerEventResponse");
        digester.addObjectCreate("DeviceManagerEventResponse/Return", Return.class);
        digester.addSetProperties("DeviceManagerEventResponse/Return");
        digester.addSetNext("DeviceManagerEventResponse/Return", "setReturn");
        digester.addObjectCreate("DeviceManagerEventResponse/ConnectResponse", ConnectResponse.class);
        digester.addSetProperties("DeviceManagerEventResponse/ConnectResponse");
        digester.addSetNext("DeviceManagerEventResponse/ConnectResponse", "setConnectResponse");
        digester.addObjectCreate("ClientCommandResponse", ClientCommandResponse.class);
        digester.addSetProperties("ClientCommandResponse");
        digester.addObjectCreate("ClientCommandResponse/Return", Return.class);
        digester.addSetProperties("ClientCommandResponse/Return");
        digester.addSetNext("ClientCommandResponse/Return", "setReturn");
        digester.addObjectCreate("ClientCommandResponse/RunningDevicesInfo", RunningDevicesInfo.class);
        digester.addSetProperties("ClientCommandResponse/RunningDevicesInfo");
        digester.addSetNext("ClientCommandResponse/RunningDevicesInfo", "setRunningDevicesInfo");
        digester.addObjectCreate("ClientCommandResponse/RunningDevicesInfo/Arrival", Arrival.class);
        digester.addSetProperties("ClientCommandResponse/RunningDevicesInfo/Arrival");
        digester.addSetNext("ClientCommandResponse/RunningDevicesInfo/Arrival", "addArrival");
        digester.addObjectCreate("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities", Capabilities.class);
        digester.addSetProperties("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities");
        digester.addSetNext("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities", "setCapabilities");
        digester.addObjectCreate("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/VideoFormats/VideoFormat", VideoFormat.class);
        digester.addSetProperties("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/VideoFormats/VideoFormat");
        digester.addSetNext("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/VideoFormats/VideoFormat", "addVideoFormat");
        digester.addObjectCreate("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType", FrameType.class);
        digester.addSetProperties("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType");
        digester.addSetNext("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/VideoFormats/VideoFormat/FrameType", "setFrameType");
        digester.addObjectCreate("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/SampleFormats/SampleFormat", SampleFormat.class);
        digester.addSetProperties("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/SampleFormats/SampleFormat");
        digester.addSetNext("ClientCommandResponse/RunningDevicesInfo/Arrival/Capabilities/SampleFormats/SampleFormat", "addSampleFormat");
        return digester;
    }
}

