/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.CaptureRequest;
import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.IDeviceContext;
import in.gov.uidai.ec.biometrics.device.IFrameListener;
import in.gov.uidai.ec.biometrics.device.INonRDImageListener;
import in.gov.uidai.ec.biometrics.device.VideoFrame;
import in.gov.uidai.ec.biometrics.device.asn1.ResponseMessage;
import in.gov.uidai.ec.biometrics.device.impl.IVDMConnectionCallback;
import in.gov.uidai.ec.biometrics.device.impl.IVDMStreamConnectionCallback;
import in.gov.uidai.ec.biometrics.device.impl.VDMConnection;
import in.gov.uidai.ec.biometrics.device.impl.VDMStreamConnection;
import in.gov.uidai.ec.biometrics.device.impl.WeakElementList;
import in.gov.uidai.ec.biometrics.device.iso.IISOImageParser;
import in.gov.uidai.ec.biometrics.device.iso.ISOImageParserProvider;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceContext
implements IDeviceContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceContext.class);
    private final WeakElementList<IFrameListener> frameListeners;
    private final WeakElementList<INonRDImageListener> imageListeners;
    private final DeviceInfo devInfo;
    private VDMConnection vdmConn;
    private VDMStreamConnection vdmStrmConn;

    DeviceContext(VDMConnection conn, DeviceInfo devInfo) {
        this.vdmConn = conn;
        this.devInfo = devInfo;
        this.frameListeners = new WeakElementList();
        this.imageListeners = new WeakElementList();
    }

    @Override
    public DeviceInfo getDeviceInformation() {
        return this.devInfo;
    }

    @Override
    public void addFrameListener(IFrameListener listener) {
        if (!this.frameListeners.contains(listener)) {
            this.frameListeners.add(listener);
        }
    }

    @Override
    public void removeFrameListener(IFrameListener listener) {
        this.frameListeners.remove(listener);
    }

    @Override
    public void addImageListener(INonRDImageListener listener) {
        if (!this.imageListeners.contains(listener)) {
            this.imageListeners.add(listener);
        }
    }

    @Override
    public void removeImageListener(INonRDImageListener listener) {
        this.imageListeners.remove(listener);
    }

    @Override
    public boolean startCapture(CaptureRequest request) {
        this.closeVDMStreamConnection();
        if (!this.vdmConn.isValid()) {
            this.vdmConn.connect();
        }
        LOGGER.debug("connection established");
        if (!this.vdmConn.isValid()) {
            this.vdmConn = null;
            return false;
        }
        this.vdmConn.setCallback(new VDMConnectionCallback());
        String videoUri = this.vdmConn.doStartCapture(request);
        if (StringUtils.isBlank((String)videoUri)) {
            return false;
        }
        this.vdmStrmConn = new VDMStreamConnection(videoUri);
        if (!this.vdmStrmConn.isValid()) {
            this.vdmStrmConn = null;
            return false;
        }
        this.vdmStrmConn.setCallback(new VDMStreamConnectionCallback());
        this.vdmStrmConn.doStartFrames();
        return true;
    }

    @Override
    public boolean endCapture() {
        this.closeVDMStreamConnection();
        if (this.vdmConn == null || !this.vdmConn.isValid()) {
            return false;
        }
        return this.vdmConn.doStopCapture();
    }

    @Override
    public boolean forceCapture() {
        this.closeVDMStreamConnection();
        if (this.vdmConn == null || !this.vdmConn.isValid()) {
            return false;
        }
        return this.vdmConn.doForceCapture();
    }

    private synchronized void closeVDMStreamConnection() {
        if (this.vdmStrmConn != null) {
            this.vdmStrmConn.doClose();
            this.vdmStrmConn = null;
        }
    }

    private class VDMStreamConnectionCallback
    implements IVDMStreamConnectionCallback {
        private VDMStreamConnectionCallback() {
        }

        @Override
        public void connectionClosed() {
            Iterator iter = DeviceContext.this.frameListeners.iterator();
            while (iter.hasNext()) {
                IFrameListener fl = (IFrameListener)iter.next();
                if (fl == null) continue;
                fl.frameReceived(new VideoFrame[0]);
            }
        }

        @Override
        public void frameReceived(ResponseMessage msg) {
            if (!msg.isBiometricSamplePresent()) {
                LOGGER.warn("no biometric sample");
                return;
            }
            IISOImageParser parser = ISOImageParserProvider.getParser(msg);
            if (parser == null) {
                LOGGER.debug("could not obtain parser for frame");
                return;
            }
            VideoFrame[] frames = parser.parseVideoFrame(msg);
            Iterator iter = DeviceContext.this.frameListeners.iterator();
            while (iter.hasNext()) {
                IFrameListener frml = (IFrameListener)iter.next();
                if (frml == null) continue;
                frml.frameReceived(frames);
            }
        }
    }

    private class VDMConnectionCallback
    implements IVDMConnectionCallback {
        private VDMConnectionCallback() {
        }

        @Override
        public void connectionClosed() {
            if (DeviceContext.this.vdmStrmConn != null) {
                DeviceContext.this.vdmStrmConn.doClose();
                DeviceContext.this.vdmStrmConn = null;
            }
        }

        @Override
        public boolean captureComplete(String sampleUri) {
            try {
                return this.captureCompleteImpl(sampleUri);
            }
            catch (Exception exep) {
                LOGGER.error("while handling capture complete", (Throwable)exep);
                return false;
            }
        }

        private boolean captureCompleteImpl(String sampleUri) {
            LOGGER.debug("called with " + sampleUri);
            DeviceContext.this.closeVDMStreamConnection();
            VDMStreamConnection sampleConn = new VDMStreamConnection(sampleUri);
            if (!sampleConn.isValid()) {
                return false;
            }
            ResponseMessage msg = sampleConn.doGetSample();
            sampleConn.doClose();
            if (msg == null) {
                return false;
            }
            LOGGER.info("captured image received");
            if (!msg.isBiometricSamplePresent()) {
                LOGGER.error("captured image does not have biometric sample");
                return false;
            }
            LOGGER.debug("captured image has biometric sample");
            CapturedImage[] capim = null;
            IISOImageParser parser = ISOImageParserProvider.getParser(msg);
            if (parser != null) {
                LOGGER.debug("parser found for captured image");
                try {
                    capim = parser.parseCaptureImage(msg);
                    LOGGER.info("captured image parsed");
                }
                catch (Exception exep) {
                    LOGGER.error("while parsing captured image", (Throwable)exep);
                }
            } else {
                LOGGER.warn("unable to find parser for captured image");
            }
            try {
                Iterator iter = DeviceContext.this.imageListeners.iterator();
                while (iter.hasNext()) {
                    INonRDImageListener il = (INonRDImageListener)iter.next();
                    if (il == null) continue;
                    LOGGER.debug("notifying image listener: " + il.getClass().getName());
                    if (capim != null && capim.length > 0) {
                        il.imageReceived(capim);
                    } else {
                        il.imageReceived(null);
                    }
                    LOGGER.debug("image listener notified");
                }
            }
            catch (Exception exep) {
                LOGGER.error("while updating image listeners", (Throwable)exep);
            }
            return true;
        }

        @Override
        public void detected(boolean flag) {
        }
    }
}

