/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IClientDeviceManager;
import in.gov.uidai.ec.biometrics.device.IDeviceLifeCycleListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;

public class DeviceLifeCycleListener
implements IDeviceLifeCycleListener,
InitializingBean {
    private final List<IDeviceStateChangeListener> deviceStartedListeners = new ArrayList<IDeviceStateChangeListener>();
    private final List<IDeviceStateChangeListener> deviceStartingListeners = new ArrayList<IDeviceStateChangeListener>();
    private final List<IDeviceStateChangeListener> deviceStoppedListeners = new ArrayList<IDeviceStateChangeListener>();
    private final List<IDeviceStateChangeListener> deviceStoppingListeners = new ArrayList<IDeviceStateChangeListener>();
    private IClientDeviceManager clientDeviceManager;

    public void setClientDeviceManager(IClientDeviceManager clientDeviceManager) {
        this.clientDeviceManager = clientDeviceManager;
    }

    public void addDeviceStartedListener(IDeviceStateChangeListener deviceStateChangeListener) {
        this.deviceStartedListeners.add(deviceStateChangeListener);
    }

    public void addDeviceStartingListener(IDeviceStateChangeListener deviceStateChangeListener) {
        this.deviceStartingListeners.add(deviceStateChangeListener);
    }

    public void addDeviceStoppedListener(IDeviceStateChangeListener deviceStateChangeListener) {
        this.deviceStoppedListeners.add(deviceStateChangeListener);
    }

    public void addDeviceStoppingListener(IDeviceStateChangeListener deviceStateChangeListener) {
        this.deviceStoppingListeners.add(deviceStateChangeListener);
    }

    @Override
    public void deviceStarted(DeviceType type) {
        if (this.deviceStartedListeners.isEmpty()) {
            return;
        }
        this.deviceStartedListeners.forEach(deviceStateChangeListener -> {
            if (deviceStateChangeListener != null) {
                deviceStateChangeListener.accept(type);
            }
        });
    }

    @Override
    public void deviceStarting(DeviceType type) {
        if (this.deviceStartingListeners.isEmpty()) {
            return;
        }
        this.deviceStartingListeners.forEach(deviceStateChangeListener -> {
            if (deviceStateChangeListener != null) {
                deviceStateChangeListener.accept(type);
            }
        });
    }

    @Override
    public void deviceStopped(DeviceType type) {
        if (this.deviceStoppedListeners.isEmpty()) {
            return;
        }
        this.deviceStoppedListeners.forEach(deviceStateChangeListener -> {
            if (deviceStateChangeListener != null) {
                deviceStateChangeListener.accept(type);
            }
        });
    }

    @Override
    public void deviceStopping(DeviceType type) {
        if (this.deviceStoppingListeners.isEmpty()) {
            return;
        }
        this.deviceStoppingListeners.forEach(deviceStateChangeListener -> {
            if (deviceStateChangeListener != null) {
                deviceStateChangeListener.accept(type);
            }
        });
    }

    public void afterPropertiesSet() throws Exception {
        this.clientDeviceManager.addLifeCycleListener(this);
        this.clientDeviceManager.getRegisteredDeviceManager().addLifeCycleListener(this);
        this.clientDeviceManager.refreshDeviceStates();
    }

    public static interface IDeviceStateChangeListener {
        public void accept(DeviceType var1);
    }
}

