/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.impl.IVDMClosedCallback;
import in.gov.uidai.ec.biometrics.device.impl.VDMConnection;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceRegistry.class);
    private List<DeviceRegistryEntry> deviceList = new ArrayList<DeviceRegistryEntry>();

    public void addDevice(String devUri, DeviceType devType, DeviceInfo devInfo) {
        DeviceRegistryEntry device2;
        for (DeviceRegistryEntry device2 : this.deviceList) {
            if (!device2.matchByType(devType) || !device2.matchByURI(devUri)) continue;
            device2.devInfo = devInfo;
            return;
        }
        VDMConnection conn = new VDMConnection(devUri);
        device2 = new DeviceRegistryEntry(devType, devUri, devInfo, conn);
        this.deviceList.add(device2);
    }

    public void removeDevice(String devUri) {
        for (DeviceRegistryEntry device : this.deviceList) {
            if (!device.matchByURI(devUri)) continue;
            try {
                device.vdmConn.doClose();
            }
            catch (Exception exep) {
                LOGGER.warn("close during removal", (Throwable)exep);
            }
            this.deviceList.remove(device);
            break;
        }
    }

    public VDMConnection getConnection(DeviceType type) {
        for (DeviceRegistryEntry device : this.deviceList) {
            if (!device.matchByType(type)) continue;
            return device.vdmConn;
        }
        return null;
    }

    public DeviceInfo getDeviceInfo(DeviceType type) {
        for (DeviceRegistryEntry device : this.deviceList) {
            if (!device.matchByType(type)) continue;
            return device.devInfo;
        }
        return null;
    }

    public DeviceType getDeviceType(String devUri) {
        for (DeviceRegistryEntry device : this.deviceList) {
            if (!device.matchByURI(devUri)) continue;
            return device.devType;
        }
        return null;
    }

    private class DeviceRegistryEntry
    implements IVDMClosedCallback {
        private DeviceType devType;
        private String devUri;
        private DeviceInfo devInfo;
        private VDMConnection vdmConn;

        DeviceRegistryEntry(DeviceType dtype, String uri, DeviceInfo dinfo, VDMConnection conn) {
            this.devType = dtype;
            this.devUri = uri;
            this.devInfo = dinfo;
            this.vdmConn = conn;
        }

        public boolean matchByType(DeviceType type) {
            if (this.devType == null) {
                return false;
            }
            if (type == null) {
                return false;
            }
            return this.devType.equals((Object)type);
        }

        public boolean matchByURI(String uri) {
            return StringUtils.equalsIgnoreCase((String)uri, (String)this.devUri);
        }

        @Override
        public void connectionClosed() {
            DeviceRegistry.this.deviceList.remove(this);
            this.vdmConn = null;
        }
    }
}

