/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.impl.IUnresolvedResponseHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class RequestResponseSync {
    private ReentrantLock theLock = new ReentrantLock();
    private Map<String, Condition> conditionMap = new HashMap<String, Condition>();
    private Map<String, Object> responseMap = new HashMap<String, Object>();
    private List<IUnresolvedResponseHandler> handlerList = new ArrayList<IUnresolvedResponseHandler>();

    public void addUnresolvedReponseHandler(IUnresolvedResponseHandler handler) {
        if (!this.handlerList.contains(handler)) {
            this.handlerList.add(handler);
        }
    }

    public void removeUnresolvedReponseHandler(IUnresolvedResponseHandler handler) {
        this.handlerList.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object waitForResponse(String reqId, long timeout) {
        this.theLock.lock();
        try {
            Condition cond = this.theLock.newCondition();
            this.conditionMap.put(reqId, cond);
            try {
                if (timeout <= 0L) {
                    cond.await();
                } else {
                    cond.await(timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.conditionMap.remove(reqId);
            Object object = this.responseMap.remove(reqId);
            return object;
        }
        finally {
            this.theLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(String reqId, Object response) {
        this.theLock.lock();
        try {
            Condition condition = this.conditionMap.remove(reqId);
            if (condition == null) {
                this.handleUnresolvedResponse(reqId, response);
            } else {
                this.responseMap.put(reqId, response);
                condition.signalAll();
            }
        }
        finally {
            this.theLock.unlock();
        }
    }

    private void handleUnresolvedResponse(String reqId, Object response) {
        for (IUnresolvedResponseHandler handler : this.handlerList) {
            try {
                handler.responseReceived(reqId, response);
            }
            catch (Exception exception) {}
        }
    }
}

