/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.CaptureRequest;
import in.gov.uidai.ec.biometrics.device.impl.IVDMClosedCallback;
import in.gov.uidai.ec.biometrics.device.impl.IVDMConnectionCallback;
import in.gov.uidai.ec.biometrics.device.impl.RequestResponseSync;
import in.gov.uidai.ec.biometrics.device.impl.XMLInputReader;
import in.gov.uidai.ec.biometrics.device.xml.CaptureComplete;
import in.gov.uidai.ec.biometrics.device.xml.Detection;
import in.gov.uidai.ec.biometrics.device.xml.DeviceCommandRequest;
import in.gov.uidai.ec.biometrics.device.xml.DeviceCommandResponse;
import in.gov.uidai.ec.biometrics.device.xml.DeviceEventRequest;
import in.gov.uidai.ec.biometrics.device.xml.DeviceEventResponse;
import in.gov.uidai.ec.biometrics.device.xml.Message;
import in.gov.uidai.ec.biometrics.device.xml.Return;
import in.gov.uidai.ec.biometrics.device.xml.StartCapture;
import in.gov.uidai.ec.biometrics.device.xml.State;
import in.gov.uidai.ec.biometrics.device.xml.UserFeedBack;
import in.gov.uidai.ec.biometrics.device.xml.Video;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.digester.Digester;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VDMConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(VDMConnection.class);
    private static final int RESPONSE_TIMEOUT = 30000;
    private final String connStr;
    private final RequestResponseSync rrs;
    private boolean validFlag;
    private Thread responseThrd;
    private Socket connSock;
    private InputStream sockIn;
    private OutputStream sockOut;
    private IVDMConnectionCallback callback;
    private IVDMClosedCallback closeCallback;

    public VDMConnection(String connStr) {
        this.connStr = connStr;
        this.validFlag = false;
        this.rrs = new RequestResponseSync();
        this.rrs.addUnresolvedReponseHandler(this::handleUnresolvedResponse);
    }

    public void connect() {
        int port;
        LOGGER.debug("connection to VDM starting");
        if (StringUtils.isBlank((String)this.connStr)) {
            LOGGER.warn("Invalid connection string");
            return;
        }
        String[] parts = this.connStr.split(":", 2);
        if (parts.length != 2) {
            LOGGER.warn("Invalid connection string");
            return;
        }
        String host = parts[0];
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException exep) {
            LOGGER.warn("Invalid connection string, bad port number");
            return;
        }
        if (port <= 0) {
            LOGGER.warn("Invalid connection string, port less than or zero");
            return;
        }
        try {
            this.connSock = new Socket(host, port);
            this.sockIn = this.connSock.getInputStream();
            this.sockOut = this.connSock.getOutputStream();
        }
        catch (Exception exep) {
            LOGGER.info("unable to open connection on port " + port);
            return;
        }
        LOGGER.debug("connected to VDM on port " + port);
        this.validFlag = true;
        this.responseThrd = new Thread(this::responseLoop);
        this.responseThrd.setDaemon(true);
        this.responseThrd.start();
        LOGGER.debug("connection to VDM complete");
    }

    public void setCallback(IVDMConnectionCallback cb) {
        this.callback = cb;
    }

    public void setClosedCallback(IVDMClosedCallback cb) {
        this.closeCallback = cb;
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public void doClose() {
        this.validFlag = false;
        if (this.responseThrd != null) {
            this.responseThrd.interrupt();
            this.responseThrd = null;
        }
        try {
            if (this.connSock != null) {
                this.sockOut.close();
                this.sockIn.close();
                this.connSock.close();
            }
        }
        catch (Exception exep) {
            LOGGER.warn("while closing connection", (Throwable)exep);
        }
        if (this.callback != null) {
            this.callback.connectionClosed();
            this.callback = null;
        }
        if (this.closeCallback != null) {
            this.closeCallback.connectionClosed();
            this.closeCallback = null;
        }
    }

    public String doStartCapture(CaptureRequest request) {
        DeviceCommandRequest devReq = new DeviceCommandRequest();
        UUID reqId = UUID.randomUUID();
        devReq.setRequestId(((Object)reqId).toString());
        devReq.setStartCapture(new StartCapture(request));
        if (!this.writeRemote(devReq)) {
            return null;
        }
        DeviceCommandResponse response = (DeviceCommandResponse)this.rrs.waitForResponse(((Object)reqId).toString(), 30000L);
        if (response == null) {
            this.doClose();
            return null;
        }
        if (!this.checkResponseReturn(response.getReturn())) {
            return null;
        }
        Video video = response.getVideo();
        if (video == null) {
            LOGGER.warn("missing video sub-tag");
            this.doClose();
            return null;
        }
        return video.getVideoURI();
    }

    public boolean doForceCapture() {
        DeviceCommandRequest request = new DeviceCommandRequest();
        UUID reqId = UUID.randomUUID();
        request.setRequestId(((Object)reqId).toString());
        request.setForceCapture();
        if (!this.writeRemote(request)) {
            return false;
        }
        DeviceCommandResponse response = (DeviceCommandResponse)this.rrs.waitForResponse(((Object)reqId).toString(), 30000L);
        if (response == null) {
            this.doClose();
            return false;
        }
        return this.checkResponseReturn(response.getReturn());
    }

    public boolean doStopCapture() {
        DeviceCommandRequest request = new DeviceCommandRequest();
        UUID reqId = UUID.randomUUID();
        request.setRequestId(((Object)reqId).toString());
        request.setStopCapture();
        if (!this.writeRemote(request)) {
            this.doClose();
            return false;
        }
        DeviceCommandResponse response = (DeviceCommandResponse)this.rrs.waitForResponse(((Object)reqId).toString(), 30000L);
        if (response == null) {
            this.doClose();
            return false;
        }
        return this.checkResponseReturn(response.getReturn());
    }

    private void responseLoop() {
        while (this.validFlag) {
            Digester digester = this.createDigester();
            try {
                digester.parse(this.sockIn);
            }
            catch (Exception exep) {
                LOGGER.debug("vdm connection closed " + exep.toString());
                this.doClose();
                break;
            }
        }
    }

    private boolean writeRemote(Object message) {
        try {
            Marshaller marshal = JAXBContext.newInstance((Class[])new Class[]{message.getClass()}).createMarshaller();
            marshal.setProperty("jaxb.fragment", (Object)true);
            if (LOGGER.isDebugEnabled()) {
                ByteArrayOutputStream logBuf = new ByteArrayOutputStream();
                marshal.setProperty("jaxb.formatted.output", (Object)true);
                marshal.marshal(message, (OutputStream)logBuf);
                LOGGER.debug("=== Outgoing Request Start ===");
                LOGGER.debug("\n" + logBuf.toString());
                LOGGER.debug("=== Outgoing Request End ===");
            }
            marshal.setProperty("jaxb.formatted.output", (Object)false);
            marshal.marshal(message, this.sockOut);
            this.sockOut.flush();
            return true;
        }
        catch (Exception exep) {
            LOGGER.debug("", (Throwable)exep);
            this.doClose();
            return false;
        }
    }

    private boolean checkResponseReturn(Return returnObj) {
        if (returnObj == null) {
            LOGGER.error("Response from VDM does not have a Return. Closing connection.");
            this.doClose();
            return false;
        }
        String retVal = returnObj.getValue();
        if (StringUtils.isBlank((String)retVal)) {
            LOGGER.error("Invalid return value");
            this.doClose();
            return false;
        }
        if (!retVal.equalsIgnoreCase("Success") && !retVal.equalsIgnoreCase("1")) {
            LOGGER.error("VDM returned: " + retVal + " Reason: " + returnObj.getFailureReason());
            return false;
        }
        return true;
    }

    private void handleUnresolvedResponse(String reqId, Object response) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unresolved response id:" + reqId + " type:" + response.getClass().getName());
        }
        if (this.callback == null) {
            return;
        }
        if (response instanceof DeviceEventRequest) {
            DeviceEventRequest der = (DeviceEventRequest)response;
            if (der.getCaptureComplete() != null) {
                boolean status = this.callback.captureComplete(der.getCaptureComplete().getSampleURI());
                DeviceEventResponse ders = new DeviceEventResponse();
                ders.setRequestId(der.getRequestId());
                Return retVal = new Return();
                ders.setReturn(retVal);
                if (status) {
                    retVal.setValue("Success");
                    retVal.setFailureReason("Success");
                } else {
                    retVal.setValue("Failure");
                    retVal.setFailureReason("InternalError_Unknown");
                }
                this.writeRemote(ders);
            } else if (der.getDetection() != null) {
                this.callback.detected(der.getDetection().isDetected());
            }
        }
    }

    private Digester createDigester() {
        XMLInputReader digester = new XMLInputReader();
        digester.setRequestResponseSync(this.rrs);
        digester.addBoundaryTag("DeviceCommandResponse");
        digester.addBoundaryTag("DeviceEventRequest");
        digester.addObjectCreate("DeviceCommandResponse", DeviceCommandResponse.class);
        digester.addSetProperties("DeviceCommandResponse");
        digester.addObjectCreate("DeviceCommandResponse/Return", Return.class);
        digester.addSetProperties("DeviceCommandResponse/Return");
        digester.addSetNext("DeviceCommandResponse/Return", "setReturn");
        digester.addObjectCreate("DeviceCommandResponse/Video", Video.class);
        digester.addSetProperties("DeviceCommandResponse/Video");
        digester.addSetNext("DeviceCommandResponse/Video", "setVideo");
        digester.addObjectCreate("DeviceCommandResponse/State", State.class);
        digester.addSetProperties("DeviceCommandResponse/State");
        digester.addSetNext("DeviceCommandResponse/State", "setState");
        digester.addObjectCreate("DeviceEventRequest", DeviceEventRequest.class);
        digester.addSetProperties("DeviceEventRequest");
        digester.addObjectCreate("DeviceEventRequest/CaptureComplete", CaptureComplete.class);
        digester.addSetProperties("DeviceEventRequest/CaptureComplete");
        digester.addSetNext("DeviceEventRequest/CaptureComplete", "setCaptureComplete");
        digester.addObjectCreate("DeviceEventRequest/Detection", Detection.class);
        digester.addSetProperties("DeviceEventRequest/Detection");
        digester.addSetNext("DeviceEventRequest/Detection", "setDetection");
        digester.addObjectCreate("DeviceEventRequest/UserFeedback", UserFeedBack.class);
        digester.addSetProperties("DeviceEventRequest/UserFeedback");
        digester.addSetNext("DeviceEventRequest/UserFeedback", "setUserFeedback");
        digester.addObjectCreate("DeviceEventRequest/UserFeedback/Message", Message.class);
        digester.addSetProperties("DeviceEventRequest/UserFeedback/Message");
        digester.addSetNext("DeviceEventRequest/UserFeedback/Message", "addMessage");
        return digester;
    }
}

