/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.asn1.RequestMessage;
import in.gov.uidai.ec.biometrics.device.asn1.ResponseMessage;
import in.gov.uidai.ec.biometrics.device.impl.IVDMStreamConnectionCallback;
import in.gov.uidai.ec.biometrics.device.impl.RequestResponseSync;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.UUID;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.bn.CoderFactory;
import org.bn.IDecoder;
import org.bn.IEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VDMStreamConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(VDMStreamConnection.class);
    private static final int RESPONSE_TIMEOUT = 30000;
    private final RequestResponseSync rrs = new RequestResponseSync();
    private boolean validFlag = false;
    private RequestLoopThread requestThrd;
    private Thread responseThrd;
    private long lastProcTime;
    private Socket connSock;
    private BufferedInputStream bufSockIn;
    private DataInputStream sockIn;
    private OutputStream sockOut;
    private IVDMStreamConnectionCallback callback;

    public VDMStreamConnection(String connStr) {
        int port;
        this.rrs.addUnresolvedReponseHandler(this::handleUnresolvedResponse);
        if (StringUtils.isBlank((String)connStr)) {
            LOGGER.warn("Invalid connection string");
            return;
        }
        String[] parts = connStr.split(":", 2);
        if (parts.length != 2) {
            LOGGER.warn("Invalid connection string");
            return;
        }
        String host = parts[0];
        try {
            port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException exep) {
            LOGGER.warn("Invalid connection string, bad port number");
            return;
        }
        if (port <= 0) {
            LOGGER.warn("Invalid connection string, port less than or zero");
            return;
        }
        try {
            this.connSock = new Socket(host, port);
            this.connSock.setReceiveBufferSize(1024768);
            this.bufSockIn = new BufferedInputStream(this.connSock.getInputStream());
            this.sockIn = new DataInputStream(this.bufSockIn);
            this.sockOut = this.connSock.getOutputStream();
        }
        catch (Exception exep) {
            LOGGER.warn("unable to open connection on port " + port);
            return;
        }
        LOGGER.info("connected on port " + port);
        this.validFlag = true;
        this.responseThrd = new Thread(this::responseLoop);
        this.responseThrd.setDaemon(true);
        this.responseThrd.start();
    }

    public void setCallback(IVDMStreamConnectionCallback clb) {
        this.callback = clb;
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public void doStartFrames() {
        if (this.requestThrd != null && this.requestThrd.isAlive()) {
            this.requestThrd.running = false;
            this.requestThrd.interrupt();
        }
        this.requestThrd = new RequestLoopThread();
        this.requestThrd.start();
    }

    public void doEndFrames() {
        if (this.requestThrd != null && this.requestThrd.isAlive()) {
            this.requestThrd.running = false;
            this.requestThrd.interrupt();
            this.requestThrd = null;
        }
    }

    public ResponseMessage doGetSample() {
        RequestMessage request = new RequestMessage();
        request.setRequestCode(0L);
        UUID uuid = UUID.randomUUID();
        request.setRequestId(uuid.toString().getBytes());
        if (!this.writeRequest(request)) {
            return null;
        }
        ResponseMessage response = (ResponseMessage)this.rrs.waitForResponse(uuid.toString(), 30000L);
        if (response == null) {
            this.doClose();
            return null;
        }
        return response;
    }

    public void doClose() {
        LOGGER.info("closing connection");
        this.validFlag = false;
        this.doEndFrames();
        if (this.responseThrd != null) {
            this.responseThrd.interrupt();
            this.responseThrd = null;
        }
        try {
            this.sockOut.close();
            this.sockIn.close();
            this.connSock.close();
        }
        catch (Exception exep) {
            LOGGER.warn("while closing connection", (Throwable)exep);
        }
        if (this.callback != null) {
            this.callback.connectionClosed();
            this.callback = null;
        }
    }

    private void responseLoop() {
        IDecoder decoder;
        try {
            decoder = CoderFactory.getInstance().newDecoder("BER");
        }
        catch (Exception exep) {
            LOGGER.error("in response loop", (Throwable)exep);
            this.doClose();
            return;
        }
        byte[] chunkData = new byte[]{};
        while (this.validFlag) {
            long time1;
            block14: {
                time1 = System.currentTimeMillis();
                try {
                    this.sockIn.mark(Integer.MAX_VALUE);
                    this.sockIn.readByte();
                    int chunkLen = this.sockIn.readUnsignedByte();
                    if (chunkLen > 128) {
                        if (chunkLen == 132) {
                            chunkLen = this.sockIn.readInt();
                        } else {
                            byte[] lenBytes = new byte[chunkLen - 128];
                            this.sockIn.readFully(lenBytes);
                            chunkLen = Integer.parseInt(new String(Hex.encodeHex((byte[])lenBytes)), 16);
                        }
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("chunkLength is: " + chunkLen);
                    }
                    if (chunkData.length < chunkLen) {
                        chunkData = new byte[chunkLen];
                    }
                    this.sockIn.readFully(chunkData, 0, chunkLen);
                    this.sockIn.reset();
                    ResponseMessage response = (ResponseMessage)decoder.decode((InputStream)this.sockIn, ResponseMessage.class);
                    String reqId = new String(response.getRequestId());
                    this.rrs.responseReceived(reqId, response);
                    if (!LOGGER.isDebugEnabled()) break block14;
                    LOGGER.debug("asn packet received");
                }
                catch (EOFException e) {
                    LOGGER.error("EOFException while reading bytes from socket");
                    this.doClose();
                    break;
                }
                catch (SocketException e) {
                    LOGGER.debug("socket is closed");
                    this.doClose();
                    break;
                }
                catch (Exception e) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.error("in response loop", (Throwable)e);
                    } else {
                        LOGGER.error("in response loop" + e.getMessage());
                    }
                    this.doClose();
                    break;
                }
            }
            long time2 = System.currentTimeMillis();
            this.lastProcTime = time2 - time1;
        }
    }

    private boolean writeRequest(RequestMessage request) {
        request.setMessageType(0L);
        try {
            IEncoder encoder = CoderFactory.getInstance().newEncoder("BER");
            encoder.encode((Object)request, this.sockOut);
            this.sockOut.flush();
        }
        catch (Exception exep) {
            LOGGER.warn(exep.getMessage(), (Throwable)exep);
            this.doClose();
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("request sent");
        }
        return true;
    }

    private void handleUnresolvedResponse(String reqId, Object response) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("unresolved response id:" + reqId + " type:" + response.getClass().getName());
        }
        if (this.callback == null) {
            return;
        }
        ResponseMessage respMsg = (ResponseMessage)response;
        try {
            this.callback.frameReceived(respMsg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RequestLoopThread
    extends Thread {
        private boolean running;

        public RequestLoopThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.running = true;
            RequestMessage request = new RequestMessage();
            request.setRequestCode(1L);
            while (this.running) {
                request.setRequestId(UUID.randomUUID().toString().getBytes());
                if (!VDMStreamConnection.this.writeRequest(request)) {
                    this.running = false;
                    break;
                }
                try {
                    if (VDMStreamConnection.this.lastProcTime < 20L) {
                        Thread.sleep(40L);
                        continue;
                    }
                    if (VDMStreamConnection.this.lastProcTime > 500L) {
                        Thread.sleep(500L);
                        continue;
                    }
                    Thread.sleep(VDMStreamConnection.this.lastProcTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.running = false;
        }
    }
}

