/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;

public class WeakElementList<E> {
    private static final Timer GC_TIMER = new Timer("Weak Element List GC", true);
    private ArrayList<WeakReference<E>> theList = new ArrayList();
    private ReferenceQueue<E> refQueue = new ReferenceQueue();
    private TimerTask gcTask = new TimerTask(){

        @Override
        public void run() {
            WeakElementList.this.gcImpl();
        }
    };

    public WeakElementList() {
        GC_TIMER.schedule(this.gcTask, 1000L);
    }

    public void add(E element) {
        this.theList.add(new WeakReference<E>(element));
    }

    public void remove(E element) {
        for (Reference reference : this.theList) {
            Object obj = reference.get();
            if (obj == null || !obj.equals(element)) continue;
            reference.enqueue();
            break;
        }
    }

    public boolean contains(E element) {
        for (Reference reference : this.theList) {
            Object obj = reference.get();
            if (obj == null || !obj.equals(element)) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.theList.clear();
    }

    public boolean isEmpty() {
        return this.theList.isEmpty();
    }

    public Iterator<E> iterator() {
        return new WeakIterator();
    }

    protected void finalize() throws Throwable {
        if (this.gcTask != null) {
            this.gcTask.cancel();
            this.gcTask = null;
        }
        GC_TIMER.purge();
        super.finalize();
    }

    /*
     * Unable to fully structure code
     */
    private void gcImpl() {
        value = null;
        block2: while (true) {
            try {
                value = this.refQueue.remove(100L);
            }
            catch (InterruptedException exep) {
                break;
            }
            if (value == null) continue;
            value = null;
            var2_2 = this.theList.iterator();
            while (true) {
                if (var2_2.hasNext()) ** break;
                continue block2;
                ref = var2_2.next();
                if (!ref.isEnqueued()) continue;
                this.theList.remove(ref);
            }
            break;
        }
        WeakElementList.GC_TIMER.purge();
    }

    private class WeakIterator
    implements Iterator<E> {
        private Iterator<WeakReference<E>> iter;

        public WeakIterator() {
            this.iter = WeakElementList.this.theList.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public E next() {
            return this.iter.next().get();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }
}

