/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.impl;

import in.gov.uidai.ec.biometrics.device.impl.DebugInputStream;
import in.gov.uidai.ec.biometrics.device.impl.RequestResponseSync;
import in.gov.uidai.ec.biometrics.device.xml.Corelational;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester.Digester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class XMLInputReader
extends Digester {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLInputReader.class);
    private List<String> boundaryList = new ArrayList<String>();
    private RequestResponseSync rrsync;
    private DebugInputStream debugIn;

    public void addBoundaryTag(String tag) {
        this.boundaryList.add(tag);
    }

    public void setRequestResponseSync(RequestResponseSync sync) {
        this.rrsync = sync;
    }

    public void addObjectCreate(String pattern, Class cls) {
        super.addObjectCreate("root/" + pattern, cls);
    }

    public void addSetProperties(String pattern) {
        super.addSetProperties("root/" + pattern);
    }

    public void addSetNext(String pattern, String methodName) {
        super.addSetNext("root/" + pattern, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parse(InputStream input) throws IOException, SAXException {
        ByteArrayInputStream ris = new ByteArrayInputStream(new String("<root>").getBytes());
        SequenceInputStream sis = new SequenceInputStream(ris, input);
        this.debugIn = new DebugInputStream(sis);
        try {
            Object object = super.parse((InputStream)this.debugIn);
            return object;
        }
        finally {
            this.logResponse();
        }
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
        if (this.boundaryList.contains(name)) {
            this.logResponse();
            Object top = this.peek();
            if (top instanceof Corelational) {
                String reqId = ((Corelational)top).getRequestId();
                this.rrsync.responseReceived(reqId, top);
            }
        }
        super.endElement(namespaceURI, localName, name);
    }

    private void logResponse() {
        if (LOGGER.isDebugEnabled() && this.debugIn != null) {
            LOGGER.debug("");
            LOGGER.debug("=== Incoming Response Start ===");
            LOGGER.debug(this.debugIn.debugAndClear());
            LOGGER.debug("=== Incoming Response End ===");
            LOGGER.debug("");
        }
    }
}

