/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.iso;

import in.gov.uidai.ec.biometrics.device.asn1.ResponseMessage;
import in.gov.uidai.ec.biometrics.device.iso.IISOImageParser;
import in.gov.uidai.ec.biometrics.device.iso._FaceParser;
import in.gov.uidai.ec.biometrics.device.iso._FingerParser;
import in.gov.uidai.ec.biometrics.device.iso._IrisParser;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ISOImageParserProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ISOImageParserProvider.class);
    private static final int IDENTIFIER_LENGTH = 4;
    private static final IISOImageParser FIR_PARSER = new _FingerParser();
    private static final IISOImageParser IIR_PARSER = new _IrisParser();
    private static final IISOImageParser FAC_PARSER = new _FaceParser();

    private ISOImageParserProvider() {
    }

    public static IISOImageParser getParser(ResponseMessage response) {
        byte[] sampleData = response.getBiometricSample().getData();
        if (sampleData == null || sampleData.length < 4) {
            if (sampleData == null) {
                LOGGER.debug("sample data is null");
            } else {
                LOGGER.debug("sample data too small");
            }
            return null;
        }
        byte[] recType = new byte[4];
        System.arraycopy(sampleData, 0, recType, 0, 4);
        String recTypeValue = new String(new Hex().encode(recType));
        if (recTypeValue.equals("46495200")) {
            return FIR_PARSER;
        }
        if (recTypeValue.equals("49495200")) {
            return IIR_PARSER;
        }
        if (recTypeValue.equals("46414300")) {
            return FAC_PARSER;
        }
        LOGGER.warn("unknown ISO identifier: {}", (Object)recTypeValue);
        return null;
    }
}

