/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.iso;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.VideoFrame;
import in.gov.uidai.ec.biometrics.device.asn1.ResponseMessage;
import in.gov.uidai.ec.biometrics.device.iso.IISOImageParser;
import in.gov.uidai.ec.biometrics.device.iso._ByteArrayToInteger;

class _FaceParser
implements IISOImageParser {
    _FaceParser() {
    }

    @Override
    public CapturedImage[] parseCaptureImage(ResponseMessage response) {
        VideoFrame[] frames = this.parseVideoFrame(response);
        CapturedImage[] arrCaptures = new CapturedImage[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            CapturedImage capture = new CapturedImage();
            capture.setEncoding(frames[i].getEncoding());
            capture.setWidth(frames[i].getWidth());
            capture.setHeight(frames[i].getHeight());
            capture.setImageData(frames[i].getData());
            capture.setOriginalData(response.getBiometricSample().getData());
            arrCaptures[i] = capture;
        }
        return arrCaptures;
    }

    @Override
    public VideoFrame[] parseVideoFrame(ResponseMessage response) {
        VideoFrame aFrame = new VideoFrame();
        VideoFrame[] arrFrames = new VideoFrame[]{aFrame};
        byte[] imgData = response.getBiometricSample().getData();
        int numFeaturePoints = _ByteArrayToInteger.read(imgData, 19, 8);
        int widhtStartPos = 36 + numFeaturePoints * 8;
        int heightStartPos = 38 + numFeaturePoints * 8;
        int fmtStartPos = 35 + numFeaturePoints * 8;
        int imgStartPos = 46 + numFeaturePoints * 8;
        int width = _ByteArrayToInteger.read(imgData, widhtStartPos, 2);
        int height = _ByteArrayToInteger.read(imgData, heightStartPos, 2);
        int imageFormatValue = _ByteArrayToInteger.read(imgData, fmtStartPos, 1);
        String imgFormat = null;
        switch (imageFormatValue) {
            case 0: {
                imgFormat = "jpeg2000";
                break;
            }
            case 1: {
                imgFormat = "jpeg2000";
                break;
            }
        }
        aFrame.setWidth(width);
        aFrame.setHeight(height);
        aFrame.setEncoding(imgFormat);
        byte[] img = new byte[imgData.length - imgStartPos];
        System.arraycopy(imgData, imgStartPos, img, 0, img.length);
        aFrame.setData(img);
        return arrFrames;
    }
}

