/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.iso;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.VideoFrame;
import in.gov.uidai.ec.biometrics.device.asn1.ResponseMessage;
import in.gov.uidai.ec.biometrics.device.iso.IISOImageParser;
import in.gov.uidai.ec.biometrics.device.iso._ByteArrayToInteger;

class _FingerParser
implements IISOImageParser {
    private static final int HEADER_LENGTH = 46;

    _FingerParser() {
    }

    @Override
    public CapturedImage[] parseCaptureImage(ResponseMessage response) {
        VideoFrame[] frames = this.parseVideoFrame(response);
        CapturedImage[] arrCaptures = new CapturedImage[frames.length];
        for (int i = 0; i < frames.length; ++i) {
            CapturedImage capture = new CapturedImage();
            capture.setEncoding(frames[i].getEncoding());
            capture.setWidth(frames[i].getWidth());
            capture.setHeight(frames[i].getHeight());
            capture.setImageData(frames[i].getData());
            capture.setOriginalData(response.getBiometricSample().getData());
            arrCaptures[i] = capture;
        }
        return arrCaptures;
    }

    @Override
    public VideoFrame[] parseVideoFrame(ResponseMessage response) {
        VideoFrame aFrame = new VideoFrame();
        VideoFrame[] arrFrames = new VideoFrame[]{aFrame};
        byte[] imgData = response.getBiometricSample().getData();
        int width = _ByteArrayToInteger.read(imgData, 41, 2);
        int height = _ByteArrayToInteger.read(imgData, 43, 2);
        int imageFormatValue = _ByteArrayToInteger.read(imgData, 28, 1);
        String imgFormat = null;
        switch (imageFormatValue) {
            case 4: {
                imgFormat = "jpeg2000";
                break;
            }
            case 3: {
                imgFormat = "jpeg2000";
                break;
            }
            case 5: {
                imgFormat = "png";
                break;
            }
        }
        aFrame.setWidth(width);
        aFrame.setHeight(height);
        aFrame.setEncoding(imgFormat);
        byte[] img = new byte[imgData.length - 46];
        System.arraycopy(imgData, 46, img, 0, img.length);
        aFrame.setData(img);
        return arrFrames;
    }
}

