/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.iso;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.VideoFrame;
import in.gov.uidai.ec.biometrics.device.asn1.ResponseMessage;
import in.gov.uidai.ec.biometrics.device.iso.IISOImageParser;
import in.gov.uidai.ec.biometrics.device.iso.IParserConstants;
import in.gov.uidai.ec.biometrics.device.iso._ByteArrayToInteger;

class _IrisParser
implements IISOImageParser,
IParserConstants {
    _IrisParser() {
    }

    @Override
    public CapturedImage[] parseCaptureImage(ResponseMessage response) {
        byte[] isoData = response.getBiometricSample().getData();
        int pointer = 0;
        byte[] recordHeader = new byte[45];
        System.arraycopy(isoData, pointer, recordHeader, 0, recordHeader.length);
        pointer += 45;
        int numEyes = _ByteArrayToInteger.read(recordHeader, 14, 1);
        int imgWidth = _ByteArrayToInteger.read(recordHeader, 23, 2);
        int imgHeight = _ByteArrayToInteger.read(recordHeader, 25, 2);
        CapturedImage[] arrCaptures = new CapturedImage[numEyes];
        for (int i = 0; i < numEyes; ++i) {
            byte[] subTypeHeader = new byte[3];
            System.arraycopy(isoData, pointer, subTypeHeader, 0, subTypeHeader.length);
            byte[] imgHeader = new byte[11];
            System.arraycopy(isoData, pointer += 3, imgHeader, 0, imgHeader.length);
            int imageLength = _ByteArrayToInteger.read(imgHeader, 7, 4);
            byte[] imgData = new byte[imageLength];
            System.arraycopy(isoData, pointer += 11, imgData, 0, imgData.length);
            pointer += imageLength;
            int splitDataLen = 59 + imageLength;
            byte[] splitData = new byte[splitDataLen];
            int sPointer = 0;
            System.arraycopy(recordHeader, 0, splitData, sPointer, 45);
            System.arraycopy(subTypeHeader, 0, splitData, sPointer += 45, 3);
            System.arraycopy(imgHeader, 0, splitData, sPointer += 3, 11);
            System.arraycopy(imgData, 0, splitData, sPointer += 11, imageLength);
            splitData[14] = 1;
            byte[] splitLenAsBytes = _ByteArrayToInteger.write(splitDataLen, 4);
            System.arraycopy(splitLenAsBytes, 0, splitData, 8, splitLenAsBytes.length);
            CapturedImage capture = new CapturedImage();
            capture.setWidth(imgWidth);
            capture.setHeight(imgHeight);
            capture.setImageData(imgData);
            capture.setOriginalData(splitData);
            arrCaptures[i] = capture;
        }
        return arrCaptures;
    }

    @Override
    public VideoFrame[] parseVideoFrame(ResponseMessage response) {
        byte[] isoData = response.getBiometricSample().getData();
        int pointer = 0;
        byte[] recordHeader = new byte[45];
        System.arraycopy(isoData, pointer, recordHeader, 0, recordHeader.length);
        pointer += 45;
        int numEyes = _ByteArrayToInteger.read(recordHeader, 14, 1);
        int imgWidth = _ByteArrayToInteger.read(recordHeader, 23, 2);
        int imgHeight = _ByteArrayToInteger.read(recordHeader, 25, 2);
        VideoFrame[] arrFrames = new VideoFrame[numEyes];
        for (int i = 0; i < numEyes; ++i) {
            VideoFrame frame = new VideoFrame();
            frame.setWidth(imgWidth);
            frame.setHeight(imgHeight);
            byte[] imgHeader = new byte[11];
            System.arraycopy(isoData, pointer += 3, imgHeader, 0, imgHeader.length);
            int imageLength = _ByteArrayToInteger.read(imgHeader, 7, 4);
            byte[] imgData = new byte[imageLength];
            System.arraycopy(isoData, pointer += 11, imgData, 0, imgData.length);
            pointer += imageLength;
            frame.setData(imgData);
            arrFrames[i] = frame;
        }
        return arrFrames;
    }
}

