/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.xml;

import in.gov.uidai.ec.biometrics.device.DeviceInfo;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.SampleFormatInfo;
import in.gov.uidai.ec.biometrics.device.VideoFormatInfo;
import in.gov.uidai.ec.biometrics.device.xml.Arrival;
import in.gov.uidai.ec.biometrics.device.xml.Capabilities;
import in.gov.uidai.ec.biometrics.device.xml.FrameType;
import in.gov.uidai.ec.biometrics.device.xml.SampleFormat;
import in.gov.uidai.ec.biometrics.device.xml.VideoFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public final class ResponseConverter {
    public static final String ONE_IRIS = "OneIris";
    public static final String TWO_IRIS = "TwoIris";
    public static final String FINGERPRINT = "FingerPrint";
    public static final String FACE = "Face";
    public static final String FINGERPRINT_SLAP = "FingerPrintSlap";
    public static final String FINGERPRINT_AUTH = "FingerPrintAuth";
    public static final String IRIS_AUTH = "IrisAuth";

    private ResponseConverter() {
    }

    public static DeviceType toDeviceType(String modality) {
        DeviceType deviceType = null;
        if (StringUtils.isBlank((String)modality)) {
            return deviceType;
        }
        if (modality.equalsIgnoreCase(FACE)) {
            deviceType = DeviceType.PHOTO;
        } else if (modality.equalsIgnoreCase(FINGERPRINT_SLAP)) {
            deviceType = DeviceType.FINGERPRINT;
        } else if (modality.equalsIgnoreCase(FINGERPRINT)) {
            deviceType = DeviceType.FINGERPRINT;
        } else if (modality.equalsIgnoreCase(ONE_IRIS)) {
            deviceType = DeviceType.IRIS;
        } else if (modality.equalsIgnoreCase(TWO_IRIS)) {
            deviceType = DeviceType.IRIS;
        } else if (modality.equalsIgnoreCase(FINGERPRINT_AUTH)) {
            deviceType = DeviceType.FINGERPRINT_AUTH;
        } else if (modality.equalsIgnoreCase(IRIS_AUTH)) {
            deviceType = DeviceType.IRIS_AUTH;
        }
        return deviceType;
    }

    public static DeviceInfo toDeviceInfo(Arrival arrival) {
        Capabilities capabilities;
        List<SampleFormat> sampleFormats;
        DeviceInfo result = new DeviceInfo();
        if (StringUtils.isNotBlank((String)arrival.getDeviceMake())) {
            result.addDeviceAttribute("device-make", arrival.getDeviceMake());
        }
        if (StringUtils.isNotBlank((String)arrival.getDeviceModel())) {
            result.addDeviceAttribute("device-model", arrival.getDeviceModel());
        }
        if (StringUtils.isNotBlank((String)arrival.getFirmwareRev())) {
            result.addDeviceAttribute("firmware-revision", arrival.getFirmwareRev());
        }
        if (StringUtils.isNotBlank((String)arrival.getHardwareRev())) {
            result.addDeviceAttribute("hardware-revision", arrival.getHardwareRev());
        }
        if (StringUtils.isNotBlank((String)arrival.getModality())) {
            result.addDeviceAttribute("modality", arrival.getModality());
        }
        if (StringUtils.isNotBlank((String)arrival.getSerialNumber())) {
            result.addDeviceAttribute("serial-num", arrival.getSerialNumber());
        }
        if (StringUtils.isNotBlank((String)arrival.getDeviceURI())) {
            result.addDeviceAttribute("device-uri", arrival.getDeviceURI());
        }
        result.addDeviceAttribute("auto-capture-supported", String.valueOf(arrival.getCapabilities().isAutoCapture()));
        result.addDeviceAttribute("disable-auto-capture-supported", String.valueOf(arrival.getCapabilities().isDisableAutoCapture()));
        result.addDeviceAttribute("detection-supported", String.valueOf(arrival.getCapabilities().isDetection()));
        result.addDeviceAttribute("video-supported", String.valueOf(arrival.getCapabilities().isDetection()));
        result.addDeviceAttribute("user-feedback-supported", String.valueOf(arrival.getCapabilities().isUserFeedback()));
        result.addDeviceAttribute("graphical-feedback-supported", String.valueOf(arrival.getCapabilities().isGraphicalFeedback()));
        List<VideoFormat> videoFormats = arrival.getCapabilities().getVideoFormats();
        if (videoFormats != null && !videoFormats.isEmpty()) {
            result.addDeviceAttribute("video-format-id", String.valueOf(videoFormats.get(0).getVideoFormatId()));
        }
        if ((sampleFormats = arrival.getCapabilities().getSampleFormats()) != null && !sampleFormats.isEmpty()) {
            result.addDeviceAttribute("sample-format-id", String.valueOf(sampleFormats.get(0).getSampleFormatId()));
        }
        if ((capabilities = arrival.getCapabilities()) != null) {
            long capVal = 0L;
            if (capabilities.isVideo()) {
                capVal |= 1L;
            }
            if (capabilities.isAutoCapture()) {
                capVal |= 2L;
            }
            if (capabilities.isDetection()) {
                capVal |= 4L;
            }
            if (capabilities.isDisableAutoCapture()) {
                capVal |= 8L;
            }
            if (capabilities.isGraphicalFeedback()) {
                capVal |= 0x10L;
            }
            if (capabilities.isUserFeedback()) {
                capVal |= 0x20L;
            }
            result.setCapabilities(capVal);
            List<SampleFormat> sfList = capabilities.getSampleFormats();
            for (SampleFormat sf : sfList) {
                result.addSampleFormat(ResponseConverter.toSampleFormatInfo(sf));
            }
            List<VideoFormat> vfList = capabilities.getVideoFormats();
            for (VideoFormat vf : vfList) {
                result.addVideoFormat(ResponseConverter.toVideoFormatInfo(vf));
            }
        }
        return result;
    }

    public static VideoFormatInfo toVideoFormatInfo(VideoFormat vidFmt) {
        VideoFormatInfo result = new VideoFormatInfo();
        result.setVideoFormatId(Integer.toString(vidFmt.getVideoFormatId()));
        result.setModality(vidFmt.getModality());
        FrameType frmType = vidFmt.getFrameType();
        if (frmType == null) {
            return result;
        }
        int width = 0;
        int height = 0;
        String size = frmType.getSize();
        if (StringUtils.isNotBlank((String)size)) {
            String[] parts = size.split(",", -1);
            if (parts.length > 0) {
                try {
                    width = Integer.parseInt(parts[0].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (parts.length >= 1) {
                try {
                    height = Integer.parseInt(parts[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        result.setWidth(width);
        result.setHeight(height);
        result.setPixelFormat(frmType.getPixelFormat());
        result.setResolution(frmType.getPixelResolution());
        return result;
    }

    public static SampleFormatInfo toSampleFormatInfo(SampleFormat samFmt) {
        SampleFormatInfo result = new SampleFormatInfo();
        result.setFormatId(Integer.toString(samFmt.getFormatId()));
        result.setSampleFormatId(samFmt.getSampleFormatId());
        result.setViews(samFmt.getViews());
        result.setResolution(samFmt.getPixelResolution());
        int width = 0;
        int height = 0;
        String size = samFmt.getSize();
        if (StringUtils.isNotBlank((String)size)) {
            String[] parts = size.split(",", -1);
            if (parts.length > 0) {
                try {
                    width = Integer.parseInt(parts[0].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (parts.length >= 1) {
                try {
                    height = Integer.parseInt(parts[1].trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        result.setWidth(width);
        result.setHeight(height);
        return result;
    }
}

