/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.device.xml;

import in.gov.uidai.ec.biometrics.device.CaptureRequest;
import in.gov.uidai.ec.biometrics.device.xml.MissingBiometric;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class StartCapture {
    private String biometricPosition;
    private boolean allowManualCapture;
    private String videoFormatId;
    private String sampleFormatId;
    private List<MissingBiometric> missingBios;

    public StartCapture() {
    }

    public StartCapture(CaptureRequest request) {
        if (request.getBiometricPosition() != null) {
            this.biometricPosition = request.getBiometricPosition().toString();
        }
        this.allowManualCapture = request.isManualCapture();
        this.videoFormatId = request.getVideoFormatId();
        this.sampleFormatId = request.getSampleFormatId();
        this.missingBios = new ArrayList<MissingBiometric>();
        for (BiometricPosition bpos : request.getMissingBiometrics()) {
            this.missingBios.add(new MissingBiometric(bpos));
        }
    }

    @XmlAttribute(name="biometricPosition")
    public String getBiometricPosition() {
        return this.biometricPosition;
    }

    @XmlAttribute(name="allowManualCapture")
    public boolean isAllowManualCapture() {
        return this.allowManualCapture;
    }

    @XmlAttribute(name="videoFormatId")
    public String getVideoFormatId() {
        return this.videoFormatId;
    }

    @XmlAttribute(name="sampleFormatId")
    public String getSampleFormatId() {
        return this.sampleFormatId;
    }

    @XmlElementWrapper(name="MissingBiometrics")
    @XmlElement(name="MissingBiometric")
    public List<MissingBiometric> getMissingBiometrics() {
        return this.missingBios;
    }
}

