/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.lvs;

import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import in.gov.uidai.ec.biometrics.lvs.LVSException;
import in.gov.uidai.ec.icas.hrmi.HrmiConnectionFactory;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LVSLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LVSLocator.class);
    private ILocalVerificationService remote;

    public LVSLocator() throws MalformedURLException {
        this("hrmi://127.0.0.1/lvs");
    }

    public LVSLocator(String url) throws MalformedURLException {
        HessianProxyFactory hpf = new HessianProxyFactory();
        hpf.setConnectTimeout(5000L);
        hpf.setReadTimeout(300000L);
        HrmiConnectionFactory hcf = new HrmiConnectionFactory();
        hpf.setConnectionFactory((HessianConnectionFactory)hcf);
        hcf.setHessianProxyFactory(hpf);
        this.remote = (ILocalVerificationService)hpf.create(ILocalVerificationService.class, url);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("service found");
        }
    }

    public static ILocalVerificationService instance() throws LVSException {
        try {
            return new LVSLocator().get();
        }
        catch (MalformedURLException e) {
            throw new LVSException(e.getMessage());
        }
    }

    public ILocalVerificationService get() {
        try {
            this.remote.ping();
        }
        catch (Exception exep) {
            LOGGER.error("LVS not accessible", (Throwable)exep);
            return null;
        }
        return this.remote;
    }
}

