/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.postcap;

import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class BioxDataAnalyzer {
    private static final List<BiometricPosition> LEFT_SLAP_ITEMS = Arrays.asList(BiometricPosition.LEFT_INDEX, BiometricPosition.LEFT_MIDDLE, BiometricPosition.LEFT_RING, BiometricPosition.LEFT_LITTLE);
    private static final List<BiometricPosition> RIGHT_SLAP_ITEMS = Arrays.asList(BiometricPosition.RIGHT_INDEX, BiometricPosition.RIGHT_MIDDLE, BiometricPosition.RIGHT_RING, BiometricPosition.RIGHT_LITTLE);
    private static final List<BiometricPosition> BOTH_THUMB_ITEMS = Arrays.asList(BiometricPosition.LEFT_THUMB, BiometricPosition.RIGHT_THUMB);
    private static final List<BiometricPosition> BOTH_IRIS_ITEMS = Arrays.asList(BiometricPosition.LEFT_IRIS, BiometricPosition.RIGHT_IRIS);

    private BioxDataAnalyzer() {
    }

    public static boolean hasExceptions(IBioxDataProvider bdp) {
        List<BiometricPosition> missingEyes = bdp.getMissingEyes();
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        return missingEyes != null && !missingEyes.isEmpty() || missingFingers != null && !missingFingers.isEmpty();
    }

    public static boolean hasLeftSlap(IBioxDataProvider bdp) {
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        return !missingFingers.containsAll(LEFT_SLAP_ITEMS) && !missingFingers.contains(BiometricPosition.LEFT_SLAP);
    }

    public static boolean hasRightSlap(IBioxDataProvider bdp) {
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        return !missingFingers.containsAll(RIGHT_SLAP_ITEMS) && !missingFingers.contains(BiometricPosition.RIGHT_SLAP);
    }

    public static boolean hasBothThumbs(IBioxDataProvider bdp) {
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        return !missingFingers.containsAll(BOTH_THUMB_ITEMS) && !missingFingers.contains(BiometricPosition.BOTH_THUMBS);
    }

    public static boolean hasLeftIris(IBioxDataProvider bdp) {
        List<BiometricPosition> missingEyes = bdp.getMissingEyes();
        return !missingEyes.contains(BiometricPosition.LEFT_IRIS) && !missingEyes.contains(BiometricPosition.BOTH_IRIS);
    }

    public static boolean hasRightIris(IBioxDataProvider bdp) {
        List<BiometricPosition> missingEyes = bdp.getMissingEyes();
        return !missingEyes.contains(BiometricPosition.RIGHT_IRIS) && !missingEyes.contains(BiometricPosition.BOTH_IRIS);
    }

    public static boolean hasBothIris(IBioxDataProvider bdp) {
        List<BiometricPosition> missingEyes = bdp.getMissingEyes();
        return !missingEyes.containsAll(BOTH_IRIS_ITEMS) && !missingEyes.contains(BiometricPosition.BOTH_IRIS);
    }

    public static List<BiometricPosition> getLeftSlapExceptions(IBioxDataProvider bdp) {
        ArrayList<BiometricPosition> result = new ArrayList<BiometricPosition>();
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        if (missingFingers.contains(BiometricPosition.LEFT_INDEX)) {
            result.add(BiometricPosition.LEFT_INDEX);
        }
        if (missingFingers.contains(BiometricPosition.LEFT_MIDDLE)) {
            result.add(BiometricPosition.LEFT_MIDDLE);
        }
        if (missingFingers.contains(BiometricPosition.LEFT_RING)) {
            result.add(BiometricPosition.LEFT_RING);
        }
        if (missingFingers.contains(BiometricPosition.LEFT_LITTLE)) {
            result.add(BiometricPosition.LEFT_LITTLE);
        }
        return result;
    }

    public static List<BiometricPosition> getRightSlapExceptions(IBioxDataProvider bdp) {
        ArrayList<BiometricPosition> result = new ArrayList<BiometricPosition>();
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        if (missingFingers.contains(BiometricPosition.RIGHT_INDEX)) {
            result.add(BiometricPosition.RIGHT_INDEX);
        }
        if (missingFingers.contains(BiometricPosition.RIGHT_MIDDLE)) {
            result.add(BiometricPosition.RIGHT_MIDDLE);
        }
        if (missingFingers.contains(BiometricPosition.RIGHT_RING)) {
            result.add(BiometricPosition.RIGHT_RING);
        }
        if (missingFingers.contains(BiometricPosition.RIGHT_LITTLE)) {
            result.add(BiometricPosition.RIGHT_LITTLE);
        }
        return result;
    }

    public static List<BiometricPosition> getThumbSlapExceptions(IBioxDataProvider bdp) {
        ArrayList<BiometricPosition> result = new ArrayList<BiometricPosition>();
        List<BiometricPosition> missingFingers = bdp.getMissingFingers();
        if (missingFingers.contains(BiometricPosition.RIGHT_THUMB)) {
            result.add(BiometricPosition.RIGHT_THUMB);
        }
        if (missingFingers.contains(BiometricPosition.LEFT_THUMB)) {
            result.add(BiometricPosition.LEFT_THUMB);
        }
        return result;
    }
}

