/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.postcap;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.biometrics.postcap.ILVSProcessor;
import in.gov.uidai.ec.biometrics.postcap.IQSSProcessor;
import in.gov.uidai.ec.biometrics.postcap.LVSProcessor;
import in.gov.uidai.ec.biometrics.postcap._FaceProcessor;
import in.gov.uidai.ec.biometrics.postcap._FingerMismatchCounter;
import in.gov.uidai.ec.biometrics.postcap._FingerProcessor;
import in.gov.uidai.ec.biometrics.postcap._IrisProcessor;
import in.gov.uidai.qssitv.model.BiometricPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptureProcessorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(CaptureProcessorFactory.class);
    private DeviceType devType;
    private IBioxDataProvider biox;
    private _FingerMismatchCounter fingerMismatchCounter;

    public CaptureProcessorFactory(DeviceType dt, IBioxDataProvider bdp) {
        this.devType = dt;
        this.biox = bdp;
    }

    public IQSSProcessor createQSSProcessor(CapturedImage capim, BiometricPosition bpos) {
        LOGGER.debug("creating processor for {}", (Object)this.devType);
        if (this.devType.equals((Object)DeviceType.PHOTO)) {
            return new _FaceProcessor(capim);
        }
        if (this.devType.equals((Object)DeviceType.FINGERPRINT)) {
            _FingerProcessor proc = new _FingerProcessor(capim);
            proc.setBiometricPosition(bpos);
            proc.setFingerMismatchCounter(this.fingerMismatchCounter);
            if (this.biox != null) {
                proc.setBioxDataProvider(this.biox);
            }
            return proc;
        }
        if (this.devType.equals((Object)DeviceType.IRIS)) {
            _IrisProcessor proc = new _IrisProcessor(capim);
            proc.setBiometricPosition(bpos);
            return proc;
        }
        return null;
    }

    public ILVSProcessor createLVSProcessor(CapturedImage capim, BiometricPosition bpos) {
        if (this.devType.equals((Object)DeviceType.FINGERPRINT) || this.devType.equals((Object)DeviceType.IRIS)) {
            return new LVSProcessor(capim, bpos);
        }
        return null;
    }

    public _FingerMismatchCounter getFingerMismatchCounter() {
        return this.fingerMismatchCounter;
    }

    public void setFingerMismatchCounter(_FingerMismatchCounter fingerMismatchCounter) {
        this.fingerMismatchCounter = fingerMismatchCounter;
    }
}

