/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.postcap;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.lvs.LVSLocator;
import in.gov.uidai.ec.biometrics.postcap.ILVSProcessor;
import in.gov.uidai.lvs.model.FingerprintSample;
import in.gov.uidai.lvs.spi.ILocalVerificationService;
import in.gov.uidai.qssitv.model.BiometricPosition;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LVSProcessor
implements ILVSProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LVSProcessor.class);
    private final CapturedImage capImg;
    private BiometricPosition bioPos;

    public LVSProcessor(CapturedImage capim, BiometricPosition bioPos) {
        this.capImg = capim;
        this.bioPos = bioPos;
    }

    @Override
    public boolean verify(String userId, String authtype) {
        try {
            ILocalVerificationService lvs = LVSLocator.instance();
            ArrayList<FingerprintSample> finsam = new ArrayList<FingerprintSample>();
            FingerprintSample sample = new FingerprintSample();
            sample.setBioPos(this.bioPos);
            sample.setSampleData(this.capImg.getOriginalData());
            finsam.add(sample);
            return lvs.verifyUser(userId, finsam, true, authtype);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return false;
        }
    }
}

