/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.postcap;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.postcap.Acceptance;
import in.gov.uidai.ec.biometrics.postcap.IQSSProcessor;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FaceQualityAttribute;
import in.gov.uidai.qssitv.model.FaceQualityFeedback;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _FaceProcessor
implements IQSSProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(_FaceProcessor.class);
    private CapturedImage capImg;
    private FaceQSS qss;
    private boolean passFlag;
    private List<Acceptance> acceptanceList;

    _FaceProcessor(CapturedImage capim) {
        this.capImg = capim;
    }

    @Override
    public boolean process() {
        this.qss = Qssitv.getInst().getQSSDataForFace(this.capImg.getOriginalData(), null);
        LOGGER.debug("face qss available: {}", (Object)(this.qss != null ? 1 : 0));
        if (this.qss != null) {
            int score = (int)this.qss.getOverallScore();
            this.capImg.setQuality(score);
            this.passFlag = this.qss.getOverallCompliance().equals((Object)Compliance.OK) && score >= 50;
            this.capImg.setImageData(this.qss.getFullFrontalFaceForDisplay());
            this.capImg.setEncoding("jpeg2000");
            this.capImg.setOriginalData(this.qss.getFullFrontalFace());
            return true;
        }
        return false;
    }

    @Override
    public Object getQSSData() {
        return this.qss;
    }

    @Override
    public CapturedImage getCapturedImage() {
        return this.capImg;
    }

    @Override
    public List<BiometricTemplate> getTemplates() {
        return null;
    }

    @Override
    public List<Acceptance> getAcceptance() {
        if (this.acceptanceList != null) {
            return this.acceptanceList;
        }
        this.acceptanceList = new ArrayList<Acceptance>();
        if (this.qss == null) {
            this.acceptanceList.add(new Acceptance(Acceptance.Level.ERROR, "qsslvs-stat:qss.none"));
            return this.acceptanceList;
        }
        if (!this.isPass()) {
            boolean feedback = false;
            for (FaceQualityFeedback fqf : this.qss.getQualityFeedback()) {
                switch (fqf.getCompliance()) {
                    case ERROR: 
                    case BELOW_THRESHOLD: 
                    case NOT_APPLIED: {
                        feedback = true;
                    }
                }
                if (!feedback) continue;
                break;
            }
            if (!feedback) {
                this.acceptanceList.add(new Acceptance(Acceptance.Level.WARN, "qsslvs-stat:qss.unaction"));
            }
        }
        boolean facenessErr = false;
        for (FaceQualityFeedback fqf : this.qss.getQualityFeedback()) {
            if (!fqf.getQualityAttribute().equals((Object)FaceQualityAttribute.FACENESS) || fqf.getCompliance().equals((Object)Compliance.OK)) continue;
            facenessErr = true;
            break;
        }
        if (facenessErr) {
            this.acceptanceList.add(new Acceptance(Acceptance.Level.WARN, "qsslvs-stat:qss.faceness"));
        }
        return this.acceptanceList;
    }

    @Override
    public boolean isPass() {
        return this.passFlag;
    }

    @Override
    public BiometricPosition getBiometricPosition() {
        return null;
    }
}

