/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.postcap;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.postcap.Acceptance;
import in.gov.uidai.ec.biometrics.postcap.BioxDataAnalyzer;
import in.gov.uidai.ec.biometrics.postcap.IBioxDataProvider;
import in.gov.uidai.ec.biometrics.postcap.IQSSProcessor;
import in.gov.uidai.ec.biometrics.postcap._FingerMismatchCounter;
import in.gov.uidai.ec.biometrics.util.BiometricsPacketUtility;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.Compliance;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FingerprintQualityFeedback;
import in.gov.uidai.qssitv.model.FormatType;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _FingerProcessor
implements IQSSProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(_FingerProcessor.class);
    private static final int SCORE_THRESHOLD = 50;
    private static final int NFIQ_THRESHOLD = 3;
    private final CapturedImage capImg;
    private IBioxDataProvider bdp;
    private BiometricPosition bioPos;
    private boolean passFlag;
    private FingerprintQSS qss;
    private List<BiometricTemplate> tplList;
    private List<Acceptance> acceptanceList;
    private _FingerMismatchCounter fingerMismatchCounter;
    private static final BiometricsPacketUtility utility = new BiometricsPacketUtility();

    public _FingerProcessor(CapturedImage capim) {
        this.capImg = capim;
    }

    public void setBioxDataProvider(IBioxDataProvider provider) {
        this.bdp = provider;
    }

    public void setFingerMismatchCounter(_FingerMismatchCounter fingerMismatchCounter) {
        this.fingerMismatchCounter = fingerMismatchCounter;
    }

    @Override
    public boolean process() {
        List<BiometricPosition> missingFingers = null;
        if (this.bdp != null && this.bioPos != null) {
            switch (this.bioPos) {
                case LEFT_SLAP: {
                    missingFingers = BioxDataAnalyzer.getLeftSlapExceptions(this.bdp);
                    break;
                }
                case RIGHT_SLAP: {
                    missingFingers = BioxDataAnalyzer.getRightSlapExceptions(this.bdp);
                    break;
                }
                case BOTH_THUMBS: {
                    missingFingers = BioxDataAnalyzer.getThumbSlapExceptions(this.bdp);
                    break;
                }
            }
        }
        this.qss = Qssitv.getInst().getQSSDataForFingerprint(this.capImg.getOriginalData(), missingFingers);
        this.tplList = Qssitv.getInst().getFingerTemplate(this.capImg.getOriginalData(), missingFingers, 0, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("missing fingers: " + missingFingers);
            LOGGER.debug("finger qss available: " + (this.qss != null));
            if (this.tplList != null) {
                LOGGER.debug("finger templates available: " + this.tplList.size());
            } else {
                LOGGER.debug("finger templates unavailable");
            }
        }
        if (this.qss != null) {
            this.drawSegmentOverlays();
            int score = (int)this.qss.getOverallScore();
            this.capImg.setQuality(score);
            this.passFlag = this.qss.getOverallCompliance().equals((Object)Compliance.OK) && score >= 50;
            this.capImg.setOriginalData(Qssitv.getInst().convertISO(this.capImg.getOriginalData(), FormatType.JPEG2));
        }
        return this.qss != null && this.tplList != null;
    }

    @Override
    public CapturedImage getCapturedImage() {
        return this.capImg;
    }

    @Override
    public Object getQSSData() {
        return this.qss;
    }

    @Override
    public List<BiometricTemplate> getTemplates() {
        return this.tplList;
    }

    @Override
    public List<Acceptance> getAcceptance() {
        if (this.acceptanceList != null) {
            return this.acceptanceList;
        }
        this.acceptanceList = new ArrayList<Acceptance>();
        if (this.qss == null) {
            this.acceptanceList.add(new Acceptance(Acceptance.Level.ERROR, "qsslvs-stat:qss.none"));
            return this.acceptanceList;
        }
        if (this.bdp != null && this.bioPos != null) {
            int numFingers = 0;
            switch (this.bioPos) {
                case LEFT_SLAP: {
                    int missingCount = BioxDataAnalyzer.getLeftSlapExceptions(this.bdp).size();
                    numFingers = 4 - missingCount;
                    break;
                }
                case RIGHT_SLAP: {
                    int missingCount = BioxDataAnalyzer.getRightSlapExceptions(this.bdp).size();
                    numFingers = 4 - missingCount;
                    break;
                }
                case BOTH_THUMBS: {
                    int missingCount = BioxDataAnalyzer.getThumbSlapExceptions(this.bdp).size();
                    numFingers = 2 - missingCount;
                    break;
                }
            }
            if (this.qss.getFingerSegments().size() == 0) {
                this.acceptanceList.add(new Acceptance(Acceptance.Level.ERROR, "qsslvs-stat:qss.finger.count"));
            }
            if (this.qss.getFingerSegments().size() != numFingers) {
                int count = 0;
                switch (this.bioPos) {
                    case LEFT_SLAP: {
                        count = this.fingerMismatchCounter.increaseLeftSlapMismatchCount();
                        break;
                    }
                    case RIGHT_SLAP: {
                        count = this.fingerMismatchCounter.increaseRightSlapMismatchCount();
                        break;
                    }
                    case BOTH_THUMBS: {
                        count = this.fingerMismatchCounter.increaseThumbsMismatchCount();
                        break;
                    }
                }
                if (count < this.fingerMismatchCounter.getMinFingerMismatchAttempts()) {
                    this.acceptanceList.add(new Acceptance(Acceptance.Level.ERROR, "qsslvs-stat:qss.finger.count"));
                } else {
                    this.acceptanceList.add(new Acceptance(Acceptance.Level.FAIL, "qsslvs-stat:qss.finger.fail"));
                }
            }
        }
        int handVal = this.qss.getHandedness();
        LOGGER.debug("handedness says: " + handVal);
        if (handVal > 0 && this.bioPos.equals((Object)BiometricPosition.LEFT_SLAP)) {
            this.acceptanceList.add(new Acceptance(Acceptance.Level.WARN, "qsslvs-stat:qss.sequencing.right"));
        }
        if (handVal < 0 && this.bioPos.equals((Object)BiometricPosition.RIGHT_SLAP)) {
            this.acceptanceList.add(new Acceptance(Acceptance.Level.WARN, "qsslvs-stat:qss.sequencing.left"));
        }
        if (!this.isPass()) {
            boolean feedback = false;
            for (FingerprintQualityFeedback fqf : this.qss.getQualityFeedback()) {
                switch (fqf.getCompliance()) {
                    case ERROR: 
                    case BELOW_THRESHOLD: 
                    case NOT_APPLIED: {
                        feedback = true;
                        break;
                    }
                }
                if (!feedback) continue;
                break;
            }
            if (!feedback) {
                this.acceptanceList.add(new Acceptance(Acceptance.Level.WARN, "qsslvs-stat:qss.unaction"));
            }
        }
        return this.acceptanceList;
    }

    @Override
    public boolean isPass() {
        return this.passFlag;
    }

    private void drawSegmentOverlays() {
        if (this.qss == null) {
            return;
        }
        List segments = this.qss.getFingerSegments();
        if (segments.isEmpty()) {
            return;
        }
        BufferedImage baseImg = this.toRenderableImage();
        int imageWidth = baseImg.getWidth();
        int imageHeight = baseImg.getHeight();
        BufferedImage bufim = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D g2d = (Graphics2D)bufim.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, imageWidth, imageHeight);
        g2d.drawImage(baseImg, null, 0, 0);
        g2d.setStroke(new BasicStroke(10.0f, 1, 1, 1.0f, new float[]{2.0f, 2.0f}, 0.0f));
        segments.forEach(segment -> {
            Point topLeft = segment.getTopLeft();
            Point topRight = segment.getTopRight();
            Point botLeft = segment.getBottomLeft();
            Point botRight = segment.getBottomRight();
            double score = segment.getQuality();
            LOGGER.debug(topLeft + " " + topRight + " " + botLeft + " " + botRight);
            LOGGER.debug("score: " + score);
            g2d.setColor(score <= 3.0 ? Color.GREEN : Color.RED);
            g2d.drawLine(topLeft.x, topLeft.y, topRight.x, topRight.y);
            g2d.drawLine(topRight.x, topRight.y, botRight.x, botRight.y);
            g2d.drawLine(botRight.x, botRight.y, botLeft.x, botLeft.y);
            g2d.drawLine(botLeft.x, botLeft.y, topLeft.x, topLeft.y);
        });
        byte[] segImgData = new byte[]{};
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ImageIO.setUseCache(false);
            ImageIO.write((RenderedImage)bufim, "png", buffer);
            buffer.flush();
            segImgData = buffer.toByteArray();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.capImg.setImageData(segImgData);
        this.capImg.setEncoding("png");
    }

    private BufferedImage toRenderableImage() {
        if (this.capImg == null) {
            return null;
        }
        byte[] data = this.capImg.getImageData();
        if (ArrayUtils.isEmpty((byte[])data)) {
            LOGGER.debug("no data in captured image");
            return null;
        }
        LOGGER.debug("image data size: " + data.length);
        if (StringUtils.isBlank((String)this.capImg.getEncoding())) {
            LOGGER.debug("processing raw image - " + this.capImg.getWidth() + "x" + this.capImg.getHeight());
            BufferedImage image = new BufferedImage(this.capImg.getWidth(), this.capImg.getHeight(), 10);
            DataBuffer dataBuf = image.getRaster().getDataBuffer();
            for (int i = 0; i < data.length - 4; ++i) {
                int pix = data[i] & 0xFF | (data[i + 1] & 0xFF) << 8;
                dataBuf.setElem(i, pix);
            }
            return image;
        }
        LOGGER.debug("processing non-raw image");
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(new ByteArrayInputStream(data));
            ImageReader imgr = ImageIO.getImageReaders(iis).next();
            if (imgr == null) {
                return null;
            }
            imgr.setInput(iis, true, true);
            BufferedImage img = imgr.read(0);
            imgr.dispose();
            if (img == null) {
                LOGGER.debug("could not decode for format " + this.capImg.getEncoding());
            }
            return img;
        }
        catch (Exception exep) {
            LOGGER.debug("", (Throwable)exep);
            return null;
        }
    }

    @Override
    public BiometricPosition getBiometricPosition() {
        return this.bioPos;
    }

    public void setBiometricPosition(BiometricPosition bpos) {
        this.bioPos = bpos;
    }
}

