/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.postcap;

import in.gov.uidai.ec.biometrics.device.CapturedImage;
import in.gov.uidai.ec.biometrics.postcap.Acceptance;
import in.gov.uidai.ec.biometrics.postcap.IQSSProcessor;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.model.FormatType;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.qssitv.model.IrisQualityFeedback;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _IrisProcessor
implements IQSSProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(_IrisProcessor.class);
    private CapturedImage capImg;
    private BiometricPosition bioPos;
    private boolean passFlag;
    private IrisQSS qss;
    private List<BiometricTemplate> tplList;
    private List<Acceptance> acceptanceList;

    _IrisProcessor(CapturedImage capim) {
        this.capImg = capim;
    }

    void setBiometricPosition(BiometricPosition bpos) {
        this.bioPos = bpos;
    }

    @Override
    public boolean process() {
        LOGGER.debug("processing for position " + this.bioPos);
        List qssList = Qssitv.getInst().getQSSDataForIris(this.capImg.getOriginalData());
        LOGGER.debug("iris qss available: " + (qssList != null));
        if (qssList != null && !qssList.isEmpty()) {
            for (IrisQSS iqss : qssList) {
                if (!this.bioPos.equals((Object)iqss.getEyePosition())) continue;
                int score = (int)iqss.getOverallScore();
                this.capImg.setQuality(score);
                this.passFlag = score >= 52;
                this.qss = iqss;
            }
        }
        this.tplList = Qssitv.getInst().getIrisTemplate(this.capImg.getOriginalData(), false);
        if (this.tplList != null) {
            LOGGER.debug("iris templates available: " + this.tplList.size());
        } else {
            LOGGER.debug("iris templates unavailable");
        }
        byte[] convDat = Qssitv.getInst().convertISO(this.capImg.getOriginalData(), FormatType.JPEG2);
        this.capImg.setOriginalData(convDat);
        return this.qss != null;
    }

    @Override
    public CapturedImage getCapturedImage() {
        return this.capImg;
    }

    @Override
    public Object getQSSData() {
        return this.qss;
    }

    @Override
    public List<BiometricTemplate> getTemplates() {
        return this.tplList;
    }

    @Override
    public List<Acceptance> getAcceptance() {
        if (this.acceptanceList != null) {
            return this.acceptanceList;
        }
        this.acceptanceList = new ArrayList<Acceptance>();
        if (this.qss == null) {
            this.acceptanceList.add(new Acceptance(Acceptance.Level.ERROR, "qsslvs-stat:qss.none"));
            return this.acceptanceList;
        }
        if (!this.isPass()) {
            boolean feedback = false;
            for (IrisQualityFeedback iqf : this.qss.getQualityFeedback()) {
                switch (iqf.getCompliance()) {
                    case ERROR: 
                    case BELOW_THRESHOLD: 
                    case NOT_APPLIED: {
                        feedback = true;
                    }
                }
                if (!feedback) continue;
                break;
            }
            if (!feedback) {
                this.acceptanceList.add(new Acceptance(Acceptance.Level.WARN, "qsslvs-stat:qss.unaction.face"));
            }
        }
        return this.acceptanceList;
    }

    @Override
    public boolean isPass() {
        return this.passFlag;
    }

    @Override
    public BiometricPosition getBiometricPosition() {
        return this.bioPos;
    }
}

