/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.qssitv;

import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import in.gov.uidai.ec.icas.hrmi.HrmiConnectionFactory;
import in.gov.uidai.qssitv.model.BiometricError;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import in.gov.uidai.qssitv.spi.IITVEngine;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HrmiITVEngine
implements IITVEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(HrmiITVEngine.class);
    private IITVEngine remote;

    public HrmiITVEngine() throws MalformedURLException {
        this("hrmi://127.0.0.1/itv");
    }

    public HrmiITVEngine(String url) throws MalformedURLException {
        HessianProxyFactory hpf = new HessianProxyFactory();
        hpf.setConnectTimeout(5000L);
        hpf.setReadTimeout(30000L);
        HrmiConnectionFactory hcf = new HrmiConnectionFactory();
        hpf.setConnectionFactory((HessianConnectionFactory)hcf);
        hcf.setHessianProxyFactory(hpf);
        this.remote = (IITVEngine)hpf.create(IITVEngine.class, url);
    }

    public boolean supportsFace() {
        return true;
    }

    public boolean supportsFinger() {
        return true;
    }

    public boolean supportsIris() {
        return true;
    }

    public List<BiometricTemplate> getFingerTemplate(byte[] input, List<BiometricPosition> missingfingers, int age, boolean iso) {
        try {
            if (this.remote.supportsFinger()) {
                return this.remote.getFingerTemplate(input, missingfingers, age, iso);
            }
            LOGGER.info("finger not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public List<BiometricTemplate> getFaceTemplate(byte[] input, boolean iso) {
        try {
            if (this.remote.supportsFace()) {
                return this.remote.getFaceTemplate(input, iso);
            }
            LOGGER.info("face not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public List<BiometricTemplate> getIrisTemplate(byte[] input, boolean iso) {
        try {
            if (this.remote.supportsIris()) {
                return this.remote.getIrisTemplate(input, iso);
            }
            LOGGER.info("iris not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public BiometricError insertFingerRecord(String encounterId, List<BiometricTemplate> fingerRecords) {
        try {
            if (this.remote.supportsFinger()) {
                return this.remote.insertFingerRecord(encounterId, fingerRecords);
            }
            LOGGER.info("finger not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public BiometricError insertFaceRecord(String encounterId, List<BiometricTemplate> faceRecords) {
        try {
            if (this.remote.supportsFace()) {
                return this.remote.insertFaceRecord(encounterId, faceRecords);
            }
            LOGGER.info("face not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public BiometricError insertIrisRecord(String encounterId, List<BiometricTemplate> irisRecords) {
        try {
            if (this.remote.supportsIris()) {
                return this.remote.insertIrisRecord(encounterId, irisRecords);
            }
            LOGGER.info("iris not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public void clearRecords() {
        try {
            this.remote.clearRecords();
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
        }
    }

    public Map<String, Double> identifyIris(List<BiometricTemplate> irisRecords, double threshold) {
        try {
            if (this.remote.supportsIris()) {
                return this.remote.identifyIris(irisRecords, threshold);
            }
            LOGGER.info("iris not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public Map<String, Double> identifyFace(List<BiometricTemplate> faceRecords, double threshold) {
        try {
            if (this.remote.supportsFace()) {
                return this.remote.identifyFace(faceRecords, threshold);
            }
            LOGGER.info("face not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public Map<String, Double> identifyFinger(List<BiometricTemplate> fingerRecords, int age, double threshold) {
        try {
            if (this.remote.supportsFinger()) {
                return this.remote.identifyFinger(fingerRecords, age, threshold);
            }
            LOGGER.info("finger not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public double verifyFinger(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        try {
            if (this.remote.supportsFinger()) {
                return this.remote.verifyFinger(probeRecord, galleryRecord);
            }
            LOGGER.info("finger not supported");
            return -1.0;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return -1.0;
        }
    }

    public double verifyIris(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        try {
            if (this.remote.supportsIris()) {
                return this.remote.verifyIris(probeRecord, galleryRecord);
            }
            LOGGER.info("iris not supported");
            return -1.0;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return -1.0;
        }
    }

    public double verifyFace(List<BiometricTemplate> probeRecord, List<BiometricTemplate> galleryRecord) {
        try {
            if (this.remote.supportsFace()) {
                return this.remote.verifyFace(probeRecord, galleryRecord);
            }
            LOGGER.info("face not supported");
            return -1.0;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return -1.0;
        }
    }
}

