/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.qssitv;

import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import in.gov.uidai.ec.icas.hrmi.HrmiConnectionFactory;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.FaceQSS;
import in.gov.uidai.qssitv.model.FingerprintQSS;
import in.gov.uidai.qssitv.model.FormatType;
import in.gov.uidai.qssitv.model.IrisQSS;
import in.gov.uidai.qssitv.model.LandMark;
import in.gov.uidai.qssitv.spi.IQSSEngine;
import java.net.MalformedURLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HrmiQSSEngine
implements IQSSEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(HrmiQSSEngine.class);
    private IQSSEngine remote;

    public HrmiQSSEngine() throws MalformedURLException {
        this("hrmi://127.0.0.1/qss");
    }

    public HrmiQSSEngine(String url) throws MalformedURLException {
        HessianProxyFactory hpf = new HessianProxyFactory();
        hpf.setConnectTimeout(5000L);
        hpf.setReadTimeout(30000L);
        HrmiConnectionFactory hcf = new HrmiConnectionFactory();
        hpf.setConnectionFactory((HessianConnectionFactory)hcf);
        hcf.setHessianProxyFactory(hpf);
        this.remote = (IQSSEngine)hpf.create(IQSSEngine.class, url);
    }

    public boolean supportsFace() {
        return true;
    }

    public boolean supportsFinger() {
        return true;
    }

    public boolean supportsIris() {
        return true;
    }

    public FaceQSS getQSSDataForFace(byte[] input, List<LandMark> landmarks) {
        try {
            if (this.remote.supportsFace()) {
                return this.remote.getQSSDataForFace(input, landmarks);
            }
            LOGGER.info("face not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public FingerprintQSS getQSSDataForFingerprint(byte[] input, List<BiometricPosition> missingFingers) {
        try {
            if (this.remote.supportsFinger()) {
                return this.remote.getQSSDataForFingerprint(input, missingFingers);
            }
            LOGGER.info("fingerprint not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public List<IrisQSS> getQSSDataForIris(byte[] input) {
        try {
            if (this.remote.supportsIris()) {
                return this.remote.getQSSDataForIris(input);
            }
            LOGGER.info("iris not supported");
            return null;
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return null;
        }
    }

    public byte[] convertISO(byte[] input, FormatType type) {
        try {
            return this.remote.convertISO(input, type);
        }
        catch (Exception exep) {
            LOGGER.error("remote exception", (Throwable)exep);
            return new byte[0];
        }
    }
}

