/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.rddup;

import in.gov.uidai.ec.biometrics.rddup.DedupError;
import in.gov.uidai.ec.biometrics.rddup.DedupStatus;
import in.gov.uidai.ec.biometrics.rddup.IResidentDedupAnalyzer;
import in.gov.uidai.ec.biometrics.rddup._AttemptScore;
import in.gov.uidai.qssitv.Qssitv;
import in.gov.uidai.qssitv.model.BiometricPosition;
import in.gov.uidai.qssitv.model.BiometricTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResidentDedupAnalyzer
implements IResidentDedupAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResidentDedupAnalyzer.class);
    private static final int MATCH_SCORE_THRESHOLD = 10;
    private static final int NFIQ_THRESHOLD = 4;
    private final Map<String, BiometricPosition> attemptPosMap = new HashMap<String, BiometricPosition>();
    private final Map<String, List<BiometricTemplate>> attemptTplMap = new HashMap<String, List<BiometricTemplate>>();
    private final Set<_AttemptScore> scoreSet;
    private final Map<String, Map<BiometricPosition, Double>> attemptNFIQScoreMap = new HashMap<String, Map<BiometricPosition, Double>>();

    public ResidentDedupAnalyzer() {
        this.scoreSet = new HashSet<_AttemptScore>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DedupError> add(BiometricPosition bioPos, String attemptId, List<BiometricTemplate> tplList, Map<BiometricPosition, Double> nfiqScoreMap) {
        ArrayList<DedupError> ddeList = new ArrayList<DedupError>();
        try {
            List<String> oppnConflicts;
            List<String> matchConflicts = this.checkMatching(attemptId, bioPos, tplList, nfiqScoreMap);
            if (!matchConflicts.isEmpty()) {
                ddeList.add(new DedupError(DedupStatus.BAD_MATCH, matchConflicts));
            }
            if (!(oppnConflicts = this.checkOppositions(bioPos, tplList)).isEmpty()) {
                ddeList.add(new DedupError(DedupStatus.DUPLICATE_BIO, oppnConflicts));
            }
            ArrayList<DedupError> arrayList = ddeList;
            return arrayList;
        }
        finally {
            this.attemptPosMap.put(attemptId, bioPos);
            this.attemptTplMap.put(attemptId, this.cloneTplList(tplList, false));
            this.attemptNFIQScoreMap.put(attemptId, nfiqScoreMap);
        }
    }

    @Override
    public void delete(String attemptId) {
        this.attemptPosMap.remove(attemptId);
        this.attemptTplMap.remove(attemptId);
        this.scoreSet.removeAll(this.findScores(attemptId));
        this.attemptNFIQScoreMap.remove(attemptId);
    }

    @Override
    public BiometricPosition getPosition(String attemptId) {
        return this.attemptPosMap.get(attemptId);
    }

    @Override
    public Map<String, Double> getScores() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        Set<String> attemptIds = this.attemptPosMap.keySet();
        for (String aid : attemptIds) {
            List<_AttemptScore> atsList = this.findScores(aid);
            double score = 0.0;
            if (!atsList.isEmpty()) {
                for (_AttemptScore ats : atsList) {
                    score += ats.getScore();
                }
                score /= (double)atsList.size();
            }
            result.put(aid, score);
        }
        return result;
    }

    @Override
    public void reset() {
        this.attemptPosMap.clear();
        this.attemptTplMap.clear();
        this.scoreSet.clear();
        this.attemptNFIQScoreMap.clear();
    }

    @Override
    public void stat() {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        LOGGER.debug("ATTEMPT - POSITION MAP");
        this.attemptPosMap.entrySet().stream().map(entry -> (String)entry.getKey() + "->" + entry.getValue());
        LOGGER.info("ATTEMPT SCORES");
        this.scoreSet.stream().map(_AttemptScore::toString);
    }

    private List<String> checkMatching(String attemptId, BiometricPosition bioPos, List<BiometricTemplate> tplList, Map<BiometricPosition, Double> nfiqScoreMap) {
        if (this.isFinger(bioPos)) {
            return this.checkFingerMatching(bioPos, tplList, nfiqScoreMap);
        }
        List<BiometricTemplate> probe = this.cloneTplList(tplList, false);
        List<String> attemptIds = this.attemptsForPosition(bioPos);
        LOGGER.debug("{} has attempts: {}", (Object)bioPos, attemptIds);
        ArrayList<String> conflictIds = new ArrayList<String>();
        for (String aid : attemptIds) {
            List<BiometricTemplate> gallery = this.attemptTplMap.get(aid);
            LOGGER.debug("gallery contains: {}", (Object)ReflectionToStringBuilder.toString(gallery));
            double score = 0.0;
            if (this.isIris(bioPos)) {
                score = Qssitv.getInst().verifyIris(probe, gallery);
            }
            _AttemptScore ats = new _AttemptScore(attemptId, aid);
            ats.setScore(score);
            this.scoreSet.add(ats);
            if (!(score < 50.0)) continue;
            conflictIds.add(aid);
        }
        return conflictIds;
    }

    private List<String> checkFingerMatching(BiometricPosition bioPos, List<BiometricTemplate> tplList, Map<BiometricPosition, Double> nfiqScoreMap) {
        List<String> attemptIds = this.attemptsForPosition(bioPos);
        LOGGER.debug("{} has attempts: {}", (Object)bioPos, attemptIds);
        List<BiometricTemplate> masterProbeList = this.cloneTplList(tplList, false);
        ArrayList<String> conflictIds = new ArrayList<String>();
        double totalScore = 0.0;
        int verifyAttempts = 0;
        for (BiometricTemplate bioTemplate : masterProbeList) {
            BiometricPosition biometricPosition = bioTemplate.getBiometricPosition();
            if (nfiqScoreMap.get(biometricPosition) >= 4.0) continue;
            ArrayList<BiometricTemplate> probeList = new ArrayList<BiometricTemplate>();
            probeList.add(bioTemplate);
            for (String aid : attemptIds) {
                List<BiometricTemplate> gallery = this.attemptTplMap.get(aid);
                ArrayList<BiometricTemplate> galleryList = new ArrayList<BiometricTemplate>();
                for (BiometricTemplate galleryTemplate : gallery) {
                    if (!galleryTemplate.getBiometricPosition().equals((Object)bioTemplate.getBiometricPosition()) || !(this.attemptNFIQScoreMap.get(aid).get(biometricPosition) <= 4.0)) continue;
                    galleryList.add(galleryTemplate);
                    break;
                }
                if (galleryList.size() <= 0) continue;
                double matchingScore = Qssitv.getInst().verifyFinger(probeList, galleryList);
                totalScore += matchingScore;
                ++verifyAttempts;
                if (!(matchingScore < 10.0) || conflictIds.contains(aid)) continue;
                conflictIds.add(aid);
            }
        }
        if (totalScore / (double)verifyAttempts > 10.0) {
            conflictIds.clear();
        }
        return conflictIds;
    }

    private List<String> checkOppositions(BiometricPosition bioPos, List<BiometricTemplate> tplList) {
        List<BiometricTemplate> probe = this.cloneTplList(tplList, true);
        BiometricPosition[] oppositions = this.getOppositions(bioPos);
        ArrayList<String> conflictIds = new ArrayList<String>();
        if (oppositions.length == 0) {
            return conflictIds;
        }
        for (BiometricPosition oBioPos : oppositions) {
            List<String> oAttemptIds = this.attemptsForPosition(oBioPos);
            for (String oaid : oAttemptIds) {
                List<BiometricTemplate> gallery = this.attemptTplMap.get(oaid);
                double score = 0.0;
                if (this.isFinger(bioPos)) {
                    score = Qssitv.getInst().verifyFinger(probe, gallery);
                } else if (this.isIris(bioPos)) {
                    score = Qssitv.getInst().verifyIris(probe, gallery);
                }
                if (!(score > 40.0)) continue;
                conflictIds.add(oaid);
            }
        }
        return conflictIds;
    }

    private boolean isFinger(BiometricPosition bioPos) {
        switch (bioPos) {
            case LEFT_SLAP: 
            case RIGHT_SLAP: 
            case BOTH_THUMBS: {
                return true;
            }
        }
        return false;
    }

    private boolean isIris(BiometricPosition bioPos) {
        switch (bioPos) {
            case LEFT_IRIS: 
            case RIGHT_IRIS: {
                return true;
            }
        }
        return false;
    }

    private BiometricPosition[] getOppositions(BiometricPosition bioPos) {
        switch (bioPos) {
            case LEFT_SLAP: {
                return new BiometricPosition[]{BiometricPosition.RIGHT_SLAP, BiometricPosition.BOTH_THUMBS};
            }
            case RIGHT_SLAP: {
                return new BiometricPosition[]{BiometricPosition.LEFT_SLAP, BiometricPosition.BOTH_THUMBS};
            }
            case BOTH_THUMBS: {
                return new BiometricPosition[]{BiometricPosition.LEFT_SLAP, BiometricPosition.RIGHT_SLAP};
            }
            case LEFT_IRIS: {
                return new BiometricPosition[]{BiometricPosition.RIGHT_IRIS};
            }
            case RIGHT_IRIS: {
                return new BiometricPosition[]{BiometricPosition.LEFT_IRIS};
            }
        }
        return new BiometricPosition[0];
    }

    private List<String> attemptsForPosition(BiometricPosition bpos) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, BiometricPosition> entry : this.attemptPosMap.entrySet()) {
            if (!entry.getValue().equals((Object)bpos)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    private List<BiometricTemplate> cloneTplList(List<BiometricTemplate> tplList, boolean unknownPos) {
        ArrayList<BiometricTemplate> result = new ArrayList<BiometricTemplate>(tplList.size());
        for (BiometricTemplate tpl : tplList) {
            BiometricTemplate tpl1 = new BiometricTemplate();
            tpl1.setProbeTemplate(tpl.getProbeTemplate());
            tpl1.setGalleryTemplate(tpl.getGalleryTemplate());
            if (unknownPos) {
                tpl1.setBiometricPosition(BiometricPosition.UNKNOWN);
            } else {
                tpl1.setBiometricPosition(tpl.getBiometricPosition());
            }
            result.add(tpl1);
        }
        return result;
    }

    private List<_AttemptScore> findScores(String attemptId) {
        ArrayList<_AttemptScore> result = new ArrayList<_AttemptScore>();
        for (_AttemptScore ats : this.scoreSet) {
            if (!ats.equalsAny(attemptId)) continue;
            result.add(ats);
        }
        return result;
    }
}

