/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.registereddevice;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.rd.device.xml.Opts;
import in.gov.uidai.ec.rd.device.xml.PidOptions;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdCaptureRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdCaptureRequest.class);
    private static final String rdVer = "1.0";
    private static final String fingerType = "2";
    private static final String irisType = "0";
    private static final String facePhotoCount = "0";
    private static final String facePhotoType = "0";
    private static final String format = "0";
    private static final String pidVer = "2.0";
    private static final String capTimeout = "10000";
    private static final String wadh = null;
    private static final String wadhKyc = "as-is";
    private static final String biPosh = "UNKNOWN";
    private final PidOptions pidOptions = new PidOptions();

    public RdCaptureRequest(String env, DeviceType deviceType, String otpForPidOptions, boolean isKyc) {
        String fingerCount = "0";
        String irisCount = "0";
        switch (deviceType) {
            case FINGERPRINT_AUTH: {
                fingerCount = "1";
                irisCount = "0";
                break;
            }
            case IRIS_AUTH: {
                fingerCount = "0";
                irisCount = "1";
            }
        }
        this.pidOptions.setVer(rdVer);
        Opts opts = new Opts();
        opts.setfCount(fingerCount);
        opts.setfType(fingerType);
        opts.setiCount(irisCount);
        opts.setiType("0");
        opts.setpCount("0");
        opts.setpType("0");
        opts.setFormat("0");
        opts.setPidVer(pidVer);
        opts.setTimeout(capTimeout);
        String otp = StringUtils.isNotBlank((String)otpForPidOptions) ? otpForPidOptions : null;
        opts.setOtp(otp);
        opts.setWadh(isKyc ? wadhKyc : wadh);
        opts.setPosh(biPosh);
        opts.setEnv(env);
        this.pidOptions.setOpts(opts);
    }

    String getPidOptions() {
        StringWriter stringWriter = new StringWriter();
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{PidOptions.class}).createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
            marshaller.marshal((Object)this.pidOptions, (Writer)stringWriter);
        }
        catch (JAXBException e) {
            LOGGER.error("Failed to marshall. ", (Throwable)e);
        }
        return stringWriter.toString().substring(55);
    }

    public String toString() {
        LinkedHashMap<String, String> request = new LinkedHashMap<String, String>();
        request.put("env", this.pidOptions.getOpts().getEnv());
        request.put("fCount", this.pidOptions.getOpts().getfCount());
        request.put("format", this.pidOptions.getOpts().getFormat());
        request.put("fType", this.pidOptions.getOpts().getfType());
        request.put("iCount", this.pidOptions.getOpts().getiCount());
        request.put("iType", this.pidOptions.getOpts().getiType());
        request.put("otp", StringUtils.isNotBlank((String)this.pidOptions.getOpts().getOtp()) ? "xxxxxx" : "");
        request.put("pCount", this.pidOptions.getOpts().getpCount());
        request.put("pidVer", this.pidOptions.getOpts().getPidVer());
        request.put("posh", this.pidOptions.getOpts().getPosh());
        request.put("pType", this.pidOptions.getOpts().getpType());
        request.put("timeout", this.pidOptions.getOpts().getTimeout());
        request.put("wadh", this.pidOptions.getOpts().getWadh());
        StringBuilder message = new StringBuilder();
        request.forEach((key, value) -> message.append(key + ": " + value + "; "));
        return message.toString();
    }
}

