/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.registereddevice;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.registereddevice.RdCaptureRequest;
import in.gov.uidai.ec.biometrics.registereddevice.RdCaptureResponse;
import in.gov.uidai.ec.biometrics.registereddevice.RdConnectionException;
import in.gov.uidai.ec.biometrics.registereddevice.RdUninitialisedException;
import in.gov.uidai.ec.rd.device.xml.DeviceRdInfo;
import in.gov.uidai.ec.rd.device.xml.Interface;
import in.gov.uidai.ec.rd.device.xml.PidData;
import in.gov.uidai.ec.rd.device.xml.RDService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RdDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdDriver.class);
    private static final String DEVICE_INFO = "DEVICEINFO";
    private static final String RD_SERVICE = "RDSERVICE";
    private static final String CAPTURE = "CAPTURE";
    private final String rdHost;
    private final int rdPort;
    private final String deviceUri;
    private RDService rdService;
    private DeviceRdInfo deviceInfo;

    RdDriver(String rdHost, int rdPort) {
        this.rdHost = rdHost;
        this.rdPort = rdPort;
        this.deviceUri = "http://" + rdHost + ":" + rdPort;
    }

    public String getUri() {
        return this.deviceUri;
    }

    synchronized void updateServiceStatus() throws Exception {
        String response = this.makeHttpClient(RD_SERVICE, this.deviceUri, null, null);
        this.rdService = (RDService)this.convertResponseXMLToObject(RDService.class, response);
    }

    public RdCaptureResponse startCapture(String rdEnvironment, DeviceType deviceType, String otpForPidOptions, boolean isKyc) throws Exception {
        RdCaptureRequest rdCaptureRequest = new RdCaptureRequest(rdEnvironment, deviceType, otpForPidOptions, isKyc);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Pid data sent to rd device during request:\n" + rdCaptureRequest);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/xml");
        String requestUrl = this.getUrl(CAPTURE);
        LOGGER.debug("Rd device request url: " + requestUrl);
        String response = this.makeHttpClient(CAPTURE, requestUrl, headers, new ByteArrayEntity(rdCaptureRequest.getPidOptions().getBytes(StandardCharsets.UTF_8)));
        LOGGER.debug("Response from rd device: " + response);
        PidData pidData = (PidData)this.convertResponseXMLToObject(PidData.class, response);
        return new RdCaptureResponse(response, pidData);
    }

    public DeviceRdInfo getDeviceInfo() {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "text/xml");
            headers.put("Content-Length", "0");
            String response = this.makeHttpClient(DEVICE_INFO, this.getUrl(DEVICE_INFO), headers, null);
            this.deviceInfo = (DeviceRdInfo)this.convertResponseXMLToObject(DeviceRdInfo.class, response);
        }
        catch (Exception e) {
            LOGGER.error("Error getting Registered Device information in context. ", (Throwable)e);
        }
        return this.deviceInfo;
    }

    boolean isDeviceActive() {
        try {
            String status = this.getRDService().getStatus();
            return status.equalsIgnoreCase("READY") || status.equalsIgnoreCase("USED");
        }
        catch (RdUninitialisedException e) {
            LOGGER.error("RD Service not initialised");
            return false;
        }
    }

    private String makeHttpClient(String verb, String uri, HashMap<String, String> headers, ByteArrayEntity body) throws IOException, RdConnectionException {
        CloseableHttpResponse httpResponse;
        RequestBuilder httpUriRequest = RequestBuilder.create((String)verb);
        httpUriRequest.setUri(uri);
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((RequestBuilder)httpUriRequest).setHeader(arg_0, arg_1));
        }
        if (body != null) {
            httpUriRequest.setEntity((HttpEntity)body);
        }
        try {
            httpResponse = HttpClientBuilder.create().build().execute(httpUriRequest.build());
        }
        catch (Exception e) {
            throw new RdConnectionException("Error connecting to Uri: " + uri);
        }
        try (BufferedReader bufRead = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));){
            String string = bufRead.lines().collect(Collectors.joining());
            return string;
        }
    }

    private Object convertResponseXMLToObject(Class klazz, String response) throws JAXBException, SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SAXSource source = new SAXSource(spf.newSAXParser().getXMLReader(), new InputSource(new StringReader(response)));
        return JAXBContext.newInstance((Class[])new Class[]{klazz}).createUnmarshaller().unmarshal((Source)source);
    }

    private synchronized RDService getRDService() throws RdUninitialisedException {
        if (this.rdService == null) {
            throw new RdUninitialisedException("Registered Device Service is not initialised");
        }
        return this.rdService;
    }

    private String getUrl(String id) throws RdUninitialisedException {
        String url = null;
        for (Interface in : this.getRDService().getInterface()) {
            String path = in.getPath();
            if (!in.getId().equalsIgnoreCase(id) || StringUtils.countMatches((String)path, (String)"/") != 2) continue;
            if (StringUtils.countMatches((String)path, (String)".") == 3 && StringUtils.countMatches((String)path, (String)":") == 1) {
                url = path.startsWith("/") ? "/" + path : "//" + path;
                continue;
            }
            url = "//" + this.rdHost + ":" + this.rdPort + (path.startsWith("/") ? path : "/" + path);
        }
        return "http:" + url;
    }
}

