/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.registereddevice;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.registereddevice.IRdConnectionCallback;
import in.gov.uidai.ec.biometrics.registereddevice.RdDriver;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceInfo;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import in.gov.uidai.ec.rd.device.xml.DeviceRdInfo;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdServiceConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(RdServiceConnection.class);
    private final RdDriver rdDriver;
    private final EcmpApiService ecmpApiService;
    private final HashMap<RegisteredDeviceInfo, String> registeredDeviceDetails = new HashMap();
    private IRdConnectionCallback callback;
    private boolean validFlag;
    private Timer heartBeatTimer;
    private boolean deviceIsActive;

    RdServiceConnection(String host, int port, IRdConnectionCallback cb, EcmpApiService ecmpApiService) throws Exception {
        this.ecmpApiService = ecmpApiService;
        this.rdDriver = new RdDriver(host, port);
        this.rdDriver.updateServiceStatus();
        this.validFlag = true;
        this.callback = cb;
        this.initialiseHeartBeat();
    }

    void doClose() {
        this.validFlag = false;
        if (this.heartBeatTimer != null) {
            this.heartBeatTimer.cancel();
        }
        if (this.deviceIsActive) {
            this.deviceIsActive = false;
            this.callback.deviceRemoved(this.rdDriver.getUri());
        }
        if (this.callback != null) {
            this.callback.connectionClosed();
            this.callback = null;
        }
    }

    public boolean isValid() {
        return this.validFlag;
    }

    private void initialiseHeartBeat() {
        this.heartBeatTimer = new Timer(true);
        TimerTask heartBeatTask = new TimerTask(){

            @Override
            public void run() {
                RdServiceConnection.this.doHeartBeat();
            }
        };
        this.heartBeatTimer.schedule(heartBeatTask, 0L, 10000L);
    }

    private void doHeartBeat() {
        try {
            this.rdDriver.updateServiceStatus();
        }
        catch (Exception e) {
            LOGGER.error("Registered Device heartbeat Error connecting to URI: " + this.rdDriver.getUri());
            this.doClose();
            return;
        }
        LOGGER.debug("heartbeat response received from RD Service URI: " + this.rdDriver.getUri());
        if (this.rdDriver.isDeviceActive() != this.deviceIsActive) {
            this.notifyDeviceStatusChange();
        }
    }

    private void notifyDeviceStatusChange() {
        DeviceRdInfo deviceInfo = this.rdDriver.getDeviceInfo();
        if (deviceInfo.getDpId() != null && this.callback != null) {
            String deviceType;
            switch (deviceType = this.getDeviceType(deviceInfo.getDpId(), deviceInfo.getRdsId(), deviceInfo.getRdsVer(), deviceInfo.getMi())) {
                case "F": {
                    this.deviceIsActive = true;
                    this.callback.deviceArrived(DeviceType.FINGERPRINT_AUTH, this.rdDriver);
                    return;
                }
                case "I": {
                    this.deviceIsActive = true;
                    this.callback.deviceArrived(DeviceType.IRIS_AUTH, this.rdDriver);
                    return;
                }
            }
        }
        LOGGER.debug("Device info not available for uri: " + this.rdDriver.getUri());
        this.doClose();
    }

    private String getDeviceType(String dpId, String rdsId, String rdsVer, String mi) {
        RegisteredDeviceInfo registeredDeviceInfo = new RegisteredDeviceInfo(dpId, rdsId, rdsVer, mi);
        String deviceType = this.registeredDeviceDetails.get(registeredDeviceInfo);
        if (deviceType == null) {
            try {
                LOGGER.info("Getting rd device type info from server for dpId: " + dpId + ", rdsId: " + rdsId + ", rdsVer: " + rdsVer + ", mi: " + mi);
                String registeredDeviceType = this.ecmpApiService.getRegisteredDeviceType(dpId, rdsId, rdsVer, mi);
                this.registeredDeviceDetails.put(registeredDeviceInfo, registeredDeviceType);
                return registeredDeviceType;
            }
            catch (Exception e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Failed to get registered device type info. Error: ", (Throwable)e);
                } else {
                    LOGGER.error("Failed to get registered device type info. Error: " + e.getMessage());
                }
                return "";
            }
        }
        return deviceType;
    }
}

