/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.registereddevice;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IFrameListener;
import in.gov.uidai.ec.biometrics.device.IGenericDeviceContext;
import in.gov.uidai.ec.biometrics.device.INonRDImageListener;
import in.gov.uidai.ec.biometrics.registereddevice.IRDImageListener;
import in.gov.uidai.ec.biometrics.registereddevice.RdCaptureException;
import in.gov.uidai.ec.biometrics.registereddevice.RdCaptureResponse;
import in.gov.uidai.ec.biometrics.registereddevice.RdDriver;
import in.gov.uidai.ec.rd.device.xml.DeviceRdInfo;
import in.gov.uidai.ec.rd.device.xml.PidData;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredDeviceContext
implements IGenericDeviceContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredDeviceContext.class);
    private final List<IFrameListener> frameListeners = new ArrayList<IFrameListener>();
    private final List<INonRDImageListener> imageListeners = new ArrayList<INonRDImageListener>();
    private final RdDriver rdDriver;

    RegisteredDeviceContext(RdDriver rdDriver) {
        this.rdDriver = rdDriver;
    }

    @Override
    public void addFrameListener(IFrameListener listener) {
        if (!this.frameListeners.contains(listener)) {
            this.frameListeners.add(listener);
        }
    }

    @Override
    public void removeFrameListener(IFrameListener listener) {
        this.frameListeners.remove(listener);
    }

    @Override
    public void addImageListener(INonRDImageListener listener) {
        if (!this.imageListeners.contains(listener)) {
            this.imageListeners.add(listener);
        }
    }

    @Override
    public void removeImageListener(INonRDImageListener listener) {
        this.imageListeners.remove(listener);
    }

    public void fireImageReceived(RdCaptureResponse rdCaptureResponse) {
        ArrayList<INonRDImageListener> clonedListeners = new ArrayList<INonRDImageListener>(this.imageListeners);
        for (INonRDImageListener listener : clonedListeners) {
            IRDImageListener rdImageListenerAdapter = (IRDImageListener)((Object)listener);
            rdImageListenerAdapter.imageReceived(rdCaptureResponse);
        }
    }

    public String getDeviceUri() {
        return this.rdDriver.getUri();
    }

    public DeviceRdInfo getDeviceInformation() {
        return this.rdDriver.getDeviceInfo();
    }

    public void startCapture(String rdEnvironment, DeviceType deviceType, String otpForPidOptions, boolean isKyc) throws Exception {
        RdCaptureResponse rdCaptureResponse = this.rdDriver.startCapture(rdEnvironment, deviceType, otpForPidOptions, isKyc);
        PidData pidData = rdCaptureResponse.getPidData();
        if (pidData == null) {
            throw new Exception("Invalid pid data");
        }
        if (!pidData.getResp().getErrCode().equalsIgnoreCase("0")) {
            LOGGER.error("Failed to get registered device capture response. responseCode = " + pidData.getResp().getErrCode());
            throw new RdCaptureException(pidData.getResp().getErrCode());
        }
        this.fireImageReceived(rdCaptureResponse);
    }

    public boolean endCapture() {
        return true;
    }
}

