/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.registereddevice;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.device.IDeviceLifeCycleListener;
import in.gov.uidai.ec.biometrics.registereddevice.IRdConnectionCallback;
import in.gov.uidai.ec.biometrics.registereddevice.IRdManagerPreference;
import in.gov.uidai.ec.biometrics.registereddevice.RdDriver;
import in.gov.uidai.ec.biometrics.registereddevice.RdServiceConnection;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceContext;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceRegistry;
import in.gov.uidai.ec.ecmpapi.EcmpApiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RegisteredDeviceManager
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredDeviceManager.class);
    private final List<IDeviceLifeCycleListener> listeners = new ArrayList<IDeviceLifeCycleListener>();
    private final RegisteredDeviceRegistry devReg = new RegisteredDeviceRegistry();
    private final HashMap<Integer, RdServiceConnection> rdConnection = new HashMap();
    private IRdManagerPreference rdmPref;
    private Timer dmTimer;
    private EcmpApiService ecmpApiService;

    public void setEcmpApiService(EcmpApiService ecmpApiService) {
        this.ecmpApiService = ecmpApiService;
    }

    public IRdManagerPreference getRdManagerPreference() {
        return this.rdmPref;
    }

    public void setRdManagerPreference(IRdManagerPreference pref) {
        this.rdmPref = pref;
    }

    public RegisteredDeviceContext getDeviceContext(DeviceType type) {
        return this.devReg.getDeviceContext(type);
    }

    public void afterPropertiesSet() {
        this.dmTimer = new Timer(true);
        this.dmTimer.schedule((TimerTask)new AutoConnectTask(), 0L);
        LOGGER.debug("registered device auto connect task scheduled");
    }

    public void destroy() {
        if (this.dmTimer != null) {
            this.dmTimer.cancel();
            this.dmTimer = null;
            LOGGER.debug("dmTimer shutdown");
        }
    }

    public synchronized void addLifeCycleListener(IDeviceLifeCycleListener listener) {
        if (!this.listeners.contains(listener)) {
            if (this.devReg.getDeviceContext(DeviceType.FINGERPRINT_AUTH) != null) {
                listener.deviceStarted(DeviceType.FINGERPRINT_AUTH);
            }
            if (this.devReg.getDeviceContext(DeviceType.IRIS_AUTH) != null) {
                listener.deviceStarted(DeviceType.IRIS_AUTH);
            }
            this.listeners.add(listener);
        }
    }

    private synchronized void fireDeviceArrived(DeviceType devType) {
        this.listeners.forEach(listener -> {
            try {
                listener.deviceStarted(devType);
            }
            catch (Exception e) {
                LOGGER.error("Failed to connect with device. ", (Throwable)e);
            }
        });
    }

    private synchronized void fireDeviceRemoved(DeviceType devType) {
        this.listeners.forEach(listener -> {
            try {
                listener.deviceStopped(devType);
            }
            catch (Exception e) {
                LOGGER.error("unable to propagate device stopped", (Throwable)e);
            }
        });
    }

    public synchronized void refreshDeviceList() {
        this.devReg.getDeviceList().forEach(devType -> this.listeners.forEach(listener -> listener.deviceStarted((DeviceType)((Object)devType))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToRdDM() {
        try {
            String dmRdHost = this.rdmPref.getRdHost();
            int minRdPort = this.rdmPref.getMinRdPortRange();
            int maxRdPort = this.rdmPref.getMaxRdPortRange();
            LOGGER.debug(String.format("Polling for Registered Device DM on %s port range %d to %d", dmRdHost, minRdPort, maxRdPort));
            IntStream.rangeClosed(minRdPort, maxRdPort).forEach(port -> {
                if (this.rdConnection.containsKey(port)) {
                    if (!this.rdConnection.get(port).isValid()) {
                        this.rdConnection.get(port).doClose();
                        this.rdConnection.remove(port);
                        LOGGER.info("registered device removed on port " + port);
                    } else {
                        return;
                    }
                }
                try {
                    RdServiceConnection conn = new RdServiceConnection(dmRdHost, port, new RDMConnectionCallback(), this.ecmpApiService);
                    LOGGER.info("found registered device connection on port " + port);
                    this.rdConnection.put(port, conn);
                }
                catch (Exception e) {
                    LOGGER.debug(e.getMessage());
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to connect with RD device");
        }
        finally {
            if (this.dmTimer != null) {
                this.dmTimer.schedule((TimerTask)new AutoConnectTask(), this.rdmPref.getAutoConnectDelay(60000L));
            }
        }
    }

    private class RDMConnectionCallback
    implements IRdConnectionCallback {
        ArrayList<String> registeredDeviceUris = new ArrayList();

        private RDMConnectionCallback() {
        }

        @Override
        public void connectionClosed() {
            this.registeredDeviceUris.forEach(RegisteredDeviceManager.this.devReg::removeDevice);
            LOGGER.debug("auto-connect task scheduled");
        }

        @Override
        public void deviceArrived(DeviceType devType, RdDriver rdDriver) {
            LOGGER.info("device arrived: [" + (Object)((Object)devType) + "] " + rdDriver.getDeviceInfo());
            RegisteredDeviceManager.this.devReg.addDevice(devType, rdDriver);
            this.registeredDeviceUris.add(rdDriver.getUri());
            RegisteredDeviceManager.this.fireDeviceArrived(devType);
        }

        @Override
        public void deviceRemoved(String devUri) {
            LOGGER.info("device removed: " + devUri);
            DeviceType devType = RegisteredDeviceManager.this.devReg.getDeviceType(devUri);
            LOGGER.debug("device type in registry is " + (Object)((Object)devType));
            RegisteredDeviceManager.this.devReg.removeDevice(devUri);
            this.registeredDeviceUris.remove(devUri);
            RegisteredDeviceManager.this.fireDeviceRemoved(devType);
        }
    }

    private class AutoConnectTask
    extends TimerTask {
        private AutoConnectTask() {
        }

        @Override
        public void run() {
            RegisteredDeviceManager.this.connectToRdDM();
        }
    }
}

