/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.registereddevice;

import in.gov.uidai.ec.biometrics.device.DeviceType;
import in.gov.uidai.ec.biometrics.registereddevice.RdDriver;
import in.gov.uidai.ec.biometrics.registereddevice.RegisteredDeviceContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

class RegisteredDeviceRegistry {
    private final List<RegistryEntry> deviceList = new ArrayList<RegistryEntry>();

    RegisteredDeviceRegistry() {
    }

    DeviceType getDeviceType(String devUri) {
        return this.deviceList.stream().filter(device -> device.matchByURI(devUri)).findFirst().map(device -> ((RegistryEntry)device).devType).orElse(null);
    }

    void addDevice(DeviceType devType, RdDriver rdDriver) {
        for (RegistryEntry device : this.deviceList) {
            if (!device.matchByType(devType) || !device.matchByURI(rdDriver.getUri())) continue;
            device.rdDriver = rdDriver;
            return;
        }
        this.deviceList.add(new RegistryEntry(devType, rdDriver));
    }

    void removeDevice(String devUri) {
        this.deviceList.stream().filter(device -> device.matchByURI(devUri)).findFirst().ifPresent(this.deviceList::remove);
    }

    List<DeviceType> getDeviceList() {
        return this.deviceList.stream().filter(Objects::nonNull).map(d -> ((RegistryEntry)d).devType).collect(Collectors.toList());
    }

    RegisteredDeviceContext getDeviceContext(DeviceType type) {
        return this.deviceList.stream().filter(device -> device != null && device.matchByType(type)).findFirst().map(device -> new RegisteredDeviceContext(((RegistryEntry)device).rdDriver)).orElse(null);
    }

    private static class RegistryEntry {
        private final DeviceType devType;
        private RdDriver rdDriver;

        RegistryEntry(DeviceType devType, RdDriver rdDriver) {
            this.devType = devType;
            this.rdDriver = rdDriver;
        }

        boolean matchByType(DeviceType type) {
            if (this.devType == null || type == null) {
                return false;
            }
            return this.devType.equals((Object)type);
        }

        boolean matchByURI(String uri) {
            return StringUtils.equalsIgnoreCase((String)uri, (String)this.rdDriver.getUri());
        }
    }
}

