/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.biometrics.util;

import in.gov.uidai.ec.biometrics.model.BodyPart;
import in.gov.uidai.ec.biometrics.model.CaptureModality;
import java.util.List;

public class BiometricsPacketUtility {
    public static String getSubTypeForIris(List<BodyPart> bodyPartList) {
        for (BodyPart bodyPart : bodyPartList) {
            switch (bodyPart) {
                case IRIS_LEFT: {
                    return "left";
                }
                case IRIS_RIGHT: {
                    return "right";
                }
            }
        }
        return null;
    }

    public String getSubTypeForFingerSlap(List<BodyPart> bodyPartList) {
        StringBuilder sBuffer = new StringBuilder();
        String subTypeMod = null;
        for (BodyPart bodyPart : bodyPartList) {
            String bodyPartName = bodyPart.name();
            if (subTypeMod == null) {
                subTypeMod = bodyPartName.substring(bodyPartName.lastIndexOf("_") + 1);
                sBuffer.append(subTypeMod.toLowerCase());
                sBuffer.append(" ");
            }
            String subTypeElements = bodyPartName.substring(0, bodyPartName.lastIndexOf("_"));
            sBuffer.append(subTypeElements.toLowerCase().replaceAll("_", "-"));
            sBuffer.append(" ");
        }
        return sBuffer.toString().trim();
    }

    public String getSubTypeForThumbSlap(List<BodyPart> bodyPartList) {
        StringBuilder sBuffer = new StringBuilder();
        String subTypeElements = "";
        for (BodyPart bodyPart : bodyPartList) {
            String bodyPartName = bodyPart.name();
            String subTypeMod = bodyPartName.substring(bodyPartName.lastIndexOf("_") + 1);
            sBuffer.append(subTypeMod.toLowerCase());
            sBuffer.append(" ");
            subTypeElements = bodyPartName.substring(0, bodyPartName.lastIndexOf("_"));
        }
        sBuffer.append(subTypeElements.toLowerCase().replaceAll("_", "-"));
        sBuffer.append(" ");
        return sBuffer.toString().trim();
    }

    public String getSubType(CaptureModality bodyPart, List<BodyPart> bodyPartList) {
        switch (bodyPart) {
            case LEFT_SLAP: 
            case RIGHT_SLAP: {
                return this.getSubTypeForFingerSlap(bodyPartList);
            }
            case THUMB_SLAP: {
                return this.getSubTypeForThumbSlap(bodyPartList);
            }
            case LEFT_IRIS: 
            case RIGHT_IRIS: {
                return BiometricsPacketUtility.getSubTypeForIris(bodyPartList);
            }
        }
        return null;
    }
}

