/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.autosuggest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSuggestCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSuggestCache.class);
    private static final int MAX_SET_SIZE = 10000;
    private static final AutoSuggestCache suggestCache = new AutoSuggestCache();
    private static final _CacheEntryComparator CEC = new _CacheEntryComparator();
    private Map<String, LinkedList<_CacheEntry>> suggestMap = new HashMap<String, LinkedList<_CacheEntry>>();

    public static AutoSuggestCache getInstance() {
        return suggestCache;
    }

    private AutoSuggestCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void load(String fileName) {
        Map ldata = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(fileName, "rw");
            long size = raf.length();
            byte[] buffer = new byte[(int)size];
            raf.readFully(buffer);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(buffer));
            ldata = (Map)ois.readObject();
        }
        catch (FileNotFoundException exep) {
            LOGGER.warn("Error while loading cache data " + exep.getMessage());
        }
        catch (Exception exep) {
            LOGGER.error("Error while loading cache data " + exep.getMessage());
            if (raf != null) {
                try {
                    raf.seek(0L);
                    raf.setLength(0L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
            }
            catch (Exception exep) {}
        }
        if (ldata == null) {
            return;
        }
        Set keys = ldata.keySet();
        for (String key : keys) {
            LinkedList<_CacheEntry> list = new LinkedList<_CacheEntry>();
            this.suggestMap.put(key, list);
            ArrayList values = ldata.get(key) != null && ldata.get(key) instanceof TreeSet ? new ArrayList((Collection)ldata.get(key)) : (ArrayList)ldata.get(key);
            for (String value : values) {
                _CacheEntry ce = new _CacheEntry();
                ce.entry = value;
                ce.numUse = 0L;
                list.add(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void store(String fileName) {
        HashMap sdata = new HashMap();
        Set<String> keys = this.suggestMap.keySet();
        for (String key : keys) {
            ArrayList<String> list = new ArrayList<String>();
            sdata.put(key, list);
            List entries = this.suggestMap.get(key);
            for (_CacheEntry ce : entries) {
                list.add(ce.entry);
            }
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(new File(fileName));
            out = new ObjectOutputStream(fos);
            out.writeObject(sdata);
        }
        catch (IOException e) {
            LOGGER.error("Error while storing data to cache", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while storing data to cache", (Throwable)e);
            }
        }
    }

    public void addEntry(String key, String value) {
        if (this.suggestMap.containsKey(key)) {
            LinkedList<_CacheEntry> entries = this.suggestMap.get(key);
            _CacheEntry sample = new _CacheEntry();
            sample.entry = value;
            sample.numUse = 1L;
            int pos = entries.indexOf(sample);
            if (pos < 0) {
                if (entries.size() >= 10000) {
                    entries.removeLast();
                }
                entries.addFirst(sample);
            } else {
                sample = entries.get(pos);
                sample.numUse++;
            }
        } else {
            LinkedList<_CacheEntry> entries = new LinkedList<_CacheEntry>();
            _CacheEntry sample = new _CacheEntry();
            sample.entry = value;
            sample.numUse = 1L;
            entries.addFirst(sample);
            this.suggestMap.put(key, entries);
        }
    }

    public List<String> getSuggestedList(String key, String prefix) {
        if (!this.suggestMap.containsKey(key)) {
            return null;
        }
        LinkedList<_CacheEntry> entries = this.suggestMap.get(key);
        ArrayList<_CacheEntry> matchingItems = new ArrayList<_CacheEntry>();
        for (_CacheEntry ce : entries) {
            if (!StringUtils.startsWithIgnoreCase((String)ce.entry, (String)prefix)) continue;
            matchingItems.add(ce);
        }
        Collections.sort(matchingItems, CEC);
        ArrayList<String> suggestedList = new ArrayList<String>(matchingItems.size());
        for (_CacheEntry ce : matchingItems) {
            suggestedList.add(ce.entry);
        }
        return suggestedList;
    }

    private static class _CacheEntryComparator
    implements Comparator<_CacheEntry> {
        private _CacheEntryComparator() {
        }

        @Override
        public int compare(_CacheEntry ce1, _CacheEntry ce2) {
            if (ce1.numUse < ce2.numUse) {
                return 1;
            }
            if (ce1.numUse == ce2.numUse) {
                return 0;
            }
            return -1;
        }
    }

    private static class _CacheEntry {
        private String entry;
        private long numUse;

        private _CacheEntry() {
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            _CacheEntry ce = (_CacheEntry)obj;
            return StringUtils.equals((String)this.entry, (String)ce.entry);
        }

        public int hashCode() {
            if (this.entry == null) {
                return -1;
            }
            return this.entry.hashCode();
        }
    }
}

