/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.hrmi;

import com.caucho.hessian.client.HessianConnection;
import com.caucho.hessian.client.HessianProxyFactory;
import in.gov.uidai.ec.icas.hrmi.IHrmiConstants;
import in.gov.uidai.ec.icas.hrmi.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HrmiConnection
implements IHrmiConstants,
HessianConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(HrmiConnection.class);
    private Properties reqHeaders = new Properties();
    private Properties respHeaders = new Properties();
    private InputStream input;
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    private Socket sock;
    private String reqPath;

    public HrmiConnection(URL url, HessianProxyFactory hpf) throws IOException {
        String protocol = url.getProtocol();
        if (!StringUtils.equalsIgnoreCase((String)"hrmi", (String)protocol)) {
            throw new IOException("bad protocol, must be hrmi");
        }
        String host = url.getHost();
        int port = url.getPort();
        if (port <= 0) {
            port = 6374;
        }
        this.sock = new Socket();
        if (hpf != null) {
            LOGGER.debug("creating with timeout values from hessian proxy factory");
            this.sock.setSoTimeout((int)hpf.getReadTimeout());
            this.sock.connect(new InetSocketAddress(host, port), (int)hpf.getConnectTimeout());
        } else {
            this.sock.connect(new InetSocketAddress(host, port));
        }
        LOGGER.debug("socket opened");
        this.reqPath = url.getFile();
        if (!this.reqPath.startsWith("/")) {
            this.reqPath = "/" + this.reqPath;
        }
        this.reqHeaders.setProperty("service-name", this.reqPath);
    }

    public void addHeader(String key, String value) {
        this.reqHeaders.setProperty(key, value);
        LOGGER.debug("added header " + key + ":" + value);
    }

    public InputStream getInputStream() throws IOException {
        LOGGER.debug("getting input stream");
        return this.input;
    }

    public OutputStream getOutputStream() throws IOException {
        LOGGER.debug("getting output stream");
        return this.output;
    }

    public void sendRequest() throws IOException {
        LOGGER.debug("sending request");
        this.output.flush();
        this.output.close();
        this.reqHeaders.setProperty("content-length", Integer.toString(this.output.size()));
        OutputStream sockOut = this.sock.getOutputStream();
        this.reqHeaders.store(sockOut, "hrmi request");
        sockOut.write(10);
        this.output.writeTo(sockOut);
        sockOut.flush();
        LOGGER.debug("request sent");
        InputStream sockIn = this.sock.getInputStream();
        this.respHeaders = StreamUtils.readHeaders(sockIn);
        LOGGER.debug("response headers are");
        LOGGER.debug(this.respHeaders.toString());
        int cntLen = 0;
        try {
            cntLen = Integer.parseInt(this.respHeaders.getProperty("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input = StreamUtils.readBody(sockIn, cntLen);
        LOGGER.debug("response received");
    }

    public void close() throws IOException {
        this.destroy();
    }

    public void destroy() throws IOException {
        if (this.sock != null) {
            this.sock.close();
        }
    }

    public int getStatusCode() {
        try {
            return Integer.parseInt(this.respHeaders.getProperty("status-code"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public String getStatusMessage() {
        return this.respHeaders.getProperty("status-message");
    }
}

