/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.hrmi;

import com.caucho.hessian.io.HessianFactory;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import in.gov.uidai.ec.icas.hrmi.HrmiLookup;
import in.gov.uidai.ec.icas.hrmi.HrmiSerializerFactory;
import in.gov.uidai.ec.icas.hrmi.IHrmiConstants;
import in.gov.uidai.ec.icas.hrmi.IHrmiLookup;
import in.gov.uidai.ec.icas.hrmi.IHrmiService;
import in.gov.uidai.ec.icas.hrmi.StreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class HrmiServiceManager
implements IHrmiConstants,
ApplicationContextAware,
InitializingBean,
DisposableBean,
BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(HrmiServiceManager.class);
    private ApplicationContext appCtxt;
    private String srvHost = "127.0.0.1";
    private int srvPort = 6374;
    private ServerSocket srvSock;
    private Thread srvThrd;
    private ThreadPoolExecutor executor;
    private boolean running;
    private Map<String, HessianSkeleton> skeletonMap = new HashMap<String, HessianSkeleton>();
    private HessianFactory hessFactory = new HessianFactory();
    private HrmiSerializerFactory hsf;

    public HrmiServiceManager() {
        this.hessFactory.getSerializerFactory().setAllowNonSerializable(true);
        this.hsf = new HrmiSerializerFactory();
        this.hsf.setAllowNonSerializable(true);
        this.hessFactory.setSerializerFactory((SerializerFactory)this.hsf);
    }

    public void setServerHost(String host) {
        this.srvHost = host;
    }

    public void setServerPort(int port) {
        this.srvPort = port;
    }

    public void setApplicationContext(ApplicationContext ctxt) {
        this.appCtxt = ctxt;
    }

    public Object postProcessAfterInitialization(Object bean, String name) throws BeansException {
        if (!this.appCtxt.isSingleton(name)) {
            return bean;
        }
        if (!(bean instanceof IHrmiService)) {
            return bean;
        }
        Class<?>[] xprtIfaces = bean.getClass().getInterfaces();
        ArrayList exportClsList = new ArrayList(Arrays.asList(xprtIfaces));
        exportClsList.remove(IHrmiService.class);
        if (exportClsList.isEmpty()) {
            return bean;
        }
        if (exportClsList.size() == 1) {
            this.bindBean(bean, exportClsList.get(0), name, false);
        } else {
            for (Class<?> exportCls : exportClsList) {
                this.bindBean(bean, exportCls, name, true);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String name) throws BeansException {
        return bean;
    }

    public void afterPropertiesSet() throws Exception {
        this.executor = new ThreadPoolExecutor(10, 10, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100));
        HrmiLookup lookup = new HrmiLookup(this.skeletonMap);
        HessianSkeleton lookupSkel = new HessianSkeleton((Object)lookup, IHrmiLookup.class);
        lookupSkel.setHessianFactory(this.hessFactory);
        this.skeletonMap.put("/", lookupSkel);
        this.srvThrd = new ServerMainThread();
        this.srvThrd.start();
    }

    public void destroy() throws Exception {
        this.running = false;
        if (this.srvThrd != null) {
            this.srvThrd.interrupt();
            this.srvThrd = null;
        }
        this.executor.shutdownNow();
    }

    private void bindBean(Object bean, Class<?> type, String name, boolean suffix) {
        if (!type.isInterface()) {
            return;
        }
        if (type.getMethods().length == 0) {
            return;
        }
        String bindName = name.trim();
        if (!bindName.startsWith("/")) {
            bindName = "/" + bindName;
        }
        if (suffix) {
            bindName = bindName + "#" + type.getName();
        }
        if (bindName.equalsIgnoreCase("/")) {
            return;
        }
        HessianSkeleton skel = new HessianSkeleton(bean, type);
        skel.setHessianFactory(this.hessFactory);
        this.skeletonMap.put(bindName, skel);
        LOGGER.debug("added " + bindName + " -> " + type.getName());
    }

    private void handleConnection(Socket sock) throws Exception {
        InputStream sockIn = sock.getInputStream();
        OutputStream sockOut = sock.getOutputStream();
        Properties respHeaders = new Properties();
        Properties reqHeaders = StreamUtils.readHeaders(sockIn);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("request headers are");
            LOGGER.debug(reqHeaders.toString());
        }
        String skelName = reqHeaders.getProperty("service-name", "");
        LOGGER.debug("request for skeleton: " + skelName);
        HessianSkeleton skel = this.skeletonMap.get(skelName.toLowerCase());
        if (skel == null) {
            LOGGER.warn("skeleton not found ");
            respHeaders.setProperty("status-code", "404");
            respHeaders.setProperty("status-message", "service not found");
            respHeaders.store(sockOut, "hrmi response");
            sockOut.write(10);
            sockOut.flush();
            sock.close();
            return;
        }
        int cntLen = 0;
        try {
            cntLen = Integer.parseInt(reqHeaders.getProperty("content-length"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        respHeaders.setProperty("status-code", "200");
        respHeaders.setProperty("status-message", "ok");
        ByteArrayOutputStream skelBuf = new ByteArrayOutputStream();
        try {
            skel.invoke(StreamUtils.readBody(sockIn, cntLen), (OutputStream)skelBuf, (SerializerFactory)this.hsf);
        }
        catch (Exception exep) {
            LOGGER.warn("exception encountered while invoking ", (Throwable)exep);
            respHeaders.setProperty("status-code", "500");
            respHeaders.setProperty("status-message", "service execution error: " + exep.toString());
        }
        skelBuf.flush();
        respHeaders.setProperty("content-length", Integer.toString(skelBuf.size()));
        respHeaders.store(sockOut, "hrmi response");
        sockOut.write(10);
        skelBuf.writeTo(sockOut);
        sockOut.flush();
        sockOut.close();
    }

    private class ConnectionHandler
    implements Runnable {
        private Socket connSock;

        public ConnectionHandler(Socket sock) {
            this.connSock = sock;
        }

        @Override
        public void run() {
            try {
                HrmiServiceManager.this.handleConnection(this.connSock);
            }
            catch (Exception exep) {
                LOGGER.warn("while handling connection", (Throwable)exep);
            }
        }
    }

    private class ServerMainThread
    extends Thread {
        public ServerMainThread() {
            this.setName("HRMI server");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            LOGGER.debug("starting HRMI service on " + HrmiServiceManager.this.srvHost + ":" + HrmiServiceManager.this.srvPort);
            try {
                HrmiServiceManager.this.srvSock = new ServerSocket(HrmiServiceManager.this.srvPort, 50, InetAddress.getByName(HrmiServiceManager.this.srvHost));
                HrmiServiceManager.this.srvSock.setSoTimeout(5000);
            }
            catch (Exception exep) {
                LOGGER.error("error creating server socket", (Throwable)exep);
                System.exit(100);
            }
            HrmiServiceManager.this.running = true;
            while (HrmiServiceManager.this.running) {
                try {
                    Socket connSock = HrmiServiceManager.this.srvSock.accept();
                    ConnectionHandler hndlr = new ConnectionHandler(connSock);
                    HrmiServiceManager.this.executor.submit(hndlr);
                }
                catch (SocketTimeoutException connSock) {
                }
                catch (RejectedExecutionException exep) {
                    LOGGER.warn(exep.getMessage(), (Throwable)exep);
                }
                catch (IOException exep) {
                    LOGGER.warn(exep.getMessage(), (Throwable)exep);
                }
                catch (Exception exep) {
                    LOGGER.warn(exep.getMessage(), (Throwable)exep);
                }
            }
        }
    }
}

