/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.hrmi;

import in.gov.uidai.ec.icas.hrmi.HrmiUrlStreamHandler;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HrmiUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(HrmiUrlStreamHandlerFactory.class);

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        LOGGER.debug("requesting stream for protocol: " + protocol);
        if (StringUtils.equalsIgnoreCase((String)protocol, (String)"hrmi")) {
            return new HrmiUrlStreamHandler();
        }
        return null;
    }

    static {
        LOGGER.debug("setting url stream handler factory");
        try {
            URL.setURLStreamHandlerFactory(new HrmiUrlStreamHandlerFactory());
        }
        catch (Error err) {
            LOGGER.error("unable to set url stream handler factory", (Throwable)err);
        }
    }
}

