/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.logging;

import in.gov.uidai.ec.icas.logging.TimeLineMap;
import in.gov.uidai.ec.icas.logging._Activity;
import in.gov.uidai.ec.icas.logging._Event;
import java.util.LinkedList;

public class TimeLine
extends _Activity {
    private _Activity lastAct;

    public static TimeLine getShared(Object name) {
        return TimeLine.getShared(name, false);
    }

    public static TimeLine getShared(TimeLineMap map, Object name) {
        return TimeLine.getShared(map, name, false);
    }

    public static TimeLine getShared(Object name, boolean autocreate) {
        return TimeLine.getShared(null, name, autocreate);
    }

    public static TimeLine getShared(TimeLineMap map, Object name, boolean autocreate) {
        TimeLine tl;
        TimeLineMap tlm = map;
        if (tlm == null) {
            tlm = TimeLineMap.getInst();
        }
        if ((tl = tlm.get(name)) != null) {
            return tl;
        }
        if (!autocreate) {
            return null;
        }
        tl = new TimeLine(name);
        tl.share();
        return tl;
    }

    public TimeLine(Object name) {
        super(name, new Object[0]);
    }

    public synchronized void activity(Object name, Object ... variables) {
        if (!this.activeFlag) {
            return;
        }
        if (this.events == null) {
            this.events = new LinkedList();
        }
        if (this.lastAct != null) {
            this.lastAct.end();
        }
        this.lastAct = new _Activity(name, variables);
        this.lastAct.level = this.level + 1;
        this.events.add(this.lastAct);
    }

    @Override
    public synchronized void event(Object name, Object ... variables) {
        if (!this.activeFlag) {
            return;
        }
        if (this.lastAct != null && this.lastAct.activeFlag) {
            this.lastAct.event(name, variables);
            return;
        }
        if (this.events == null) {
            this.events = new LinkedList();
        }
        _Event moment = new _Event(name, variables);
        moment.level = this.level + 1;
        this.events.add(moment);
    }

    @Override
    public void end() {
        this.unshare();
        if (!this.activeFlag) {
            return;
        }
        if (this.lastAct != null) {
            this.lastAct.end();
        }
        super.end();
        if (this.level == 0) {
            this.log();
        }
    }

    public synchronized TimeLine createNested(Object name) {
        if (!this.activeFlag) {
            return null;
        }
        if (this.events == null) {
            this.events = new LinkedList();
        }
        if (this.lastAct != null) {
            this.lastAct.end();
        }
        TimeLine tl = new TimeLine(name);
        tl.level = this.level + 1;
        this.lastAct = tl;
        this.events.add(this.lastAct);
        return tl;
    }

    public void share() {
        this.share(null, this.name);
    }

    public void share(TimeLineMap map) {
        this.share(map, this.name);
    }

    public void share(Object key) {
        this.share(null, key);
    }

    public void share(TimeLineMap map, Object key) {
        TimeLine tl;
        TimeLineMap tlm = map;
        if (tlm == null) {
            tlm = TimeLineMap.getInst();
        }
        if ((tl = tlm.get(key)) != null) {
            if (tl.equals(this)) {
                return;
            }
            tl.end();
        }
        tlm.set(key, this);
    }

    public void unshare() {
        this.unshare(null, null);
    }

    public void unshare(Object key) {
        this.unshare(null, key);
    }

    public void unshare(TimeLineMap map) {
        this.unshare(map, null);
    }

    public void unshare(TimeLineMap map, Object key) {
        TimeLineMap tlm = map;
        if (tlm == null) {
            tlm = TimeLineMap.getInst();
        }
        if (key != null) {
            tlm.remove(key);
        } else {
            tlm.removeByValue(this);
        }
    }
}

