/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.logging;

import in.gov.uidai.ec.icas.logging.TimeLine;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class TimeLineMap {
    private static final LocalTimeLineMap LTLM = new LocalTimeLineMap();
    private static final WeakHashMap<TimeLineMap, String> GLOBAL_TLM = new WeakHashMap();
    private String mapName;
    private Map<Object, TimeLine> timelines;

    public static TimeLineMap getInst() {
        return (TimeLineMap)LTLM.get();
    }

    public static void setInst(TimeLineMap tlm) {
        LTLM.set(tlm);
    }

    private TimeLineMap() {
        SecureRandom random = new SecureRandom();
        this.timelines = new HashMap<Object, TimeLine>();
        this.mapName = Long.toString(System.currentTimeMillis(), 36) + ":" + Integer.toString(random.nextInt() * 1000, 36);
        this.mapName = this.mapName.toUpperCase();
        GLOBAL_TLM.put(this, this.mapName);
    }

    public String name() {
        return this.mapName;
    }

    public synchronized TimeLine get(Object name) {
        return this.timelines.get(name);
    }

    public synchronized void set(Object name, TimeLine tl) {
        this.timelines.put(name, tl);
    }

    public synchronized void remove(Object name) {
        this.timelines.remove(name);
    }

    public void removeByValue(TimeLine value) {
        Object[] names;
        for (Object name : names = this.timelines.keySet().toArray()) {
            TimeLine tl = this.timelines.get(name);
            if (tl == null || !tl.equals(value)) continue;
            this.timelines.remove(name);
        }
    }

    public synchronized void endAll() {
        TimeLine[] tlines;
        for (TimeLine tl : tlines = this.timelines.values().toArray(new TimeLine[0])) {
            tl.end();
        }
    }

    public void finalize() {
        this.endAll();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownActivities()));
    }

    private static class ShutdownActivities
    implements Runnable {
        private ShutdownActivities() {
        }

        @Override
        public void run() {
            TimeLineMap[] tlMaps;
            for (TimeLineMap tlm : tlMaps = GLOBAL_TLM.keySet().toArray(new TimeLineMap[0])) {
                tlm.endAll();
            }
        }
    }

    private static class LocalTimeLineMap
    extends ThreadLocal<TimeLineMap> {
        private LocalTimeLineMap() {
        }

        @Override
        protected TimeLineMap initialValue() {
            return new TimeLineMap();
        }
    }
}

