/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UIDLogManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UIDLogManager.class);
    private static final String LOG_DIR = "./logs";
    private static final String ARCHIVE_DIR = "./data/archive";

    private UIDLogManager() {
    }

    public static void setup(String configPath) {
        JoranConfigurator jc = new JoranConfigurator();
        ClassLoader cldr = UIDLogManager.class.getClassLoader();
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            jc.setContext((Context)lc);
            lc.reset();
            jc.doConfigure(cldr.getResource(configPath));
        }
        catch (Exception exep) {
            LOGGER.error("Error setting up UIDLogManager " + exep.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void archive() {
        File srcDir = new File(LOG_DIR);
        if (!srcDir.exists() || !srcDir.isDirectory()) {
            return;
        }
        String[] fileNames = srcDir.list();
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        String outName = Long.toString(System.currentTimeMillis(), 36).toLowerCase();
        File outFile = new File(ARCHIVE_DIR);
        if (!outFile.exists()) {
            boolean dir = outFile.mkdirs();
            if (dir) {
                LOGGER.info("Directory created");
            } else {
                LOGGER.info("Directory not created");
            }
        }
        outFile = new File(outFile, outName + ".logs.zip");
        FileOutputStream fos = null;
        ZipOutputStream zos = null;
        try {
            fos = new FileOutputStream(outFile);
            zos = new ZipOutputStream(fos);
            zos.setLevel(9);
            for (String fName : fileNames) {
                ZipEntry ze = new ZipEntry(fName);
                zos.putNextEntry(ze);
                byte[] chunk = new byte[524288];
                try (FileInputStream fis = null;){
                    int oneByte;
                    fis = new FileInputStream(new File(srcDir, fName));
                    while ((oneByte = fis.read()) >= 0) {
                        zos.write(oneByte);
                        int amount = fis.read(chunk);
                        zos.write(chunk, 0, amount);
                    }
                }
                zos.closeEntry();
                zos.flush();
            }
        }
        catch (IOException exep) {
            LOGGER.error("Error archiving logs", (Throwable)exep);
            return;
        }
        finally {
            try {
                if (fos != null) {
                    fos.flush();
                    fos.close();
                }
            }
            catch (Exception exep) {
                LOGGER.error("Exception ", (Throwable)exep);
            }
        }
        for (String fName : fileNames) {
            File f = new File(srcDir, fName);
            RandomAccessFile raf = null;
            if (f.delete()) continue;
            try {
                raf = new RandomAccessFile(f, "rws");
                raf.setLength(0L);
                raf.close();
            }
            catch (Exception exep) {
                LOGGER.error("Error resetting file " + f.getAbsolutePath(), (Throwable)exep);
            }
            finally {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final long getArchiveSize() {
        File archiveDir = new File(ARCHIVE_DIR);
        File[] archives = archiveDir.listFiles(new LogFileFilter());
        long result = 0L;
        if (archives == null) {
            return result;
        }
        for (File f : archives) {
            result += f.length();
        }
        return result;
    }

    public static final void export(String outPath) {
        File outDir = new File(outPath);
        File archiveDir = new File(ARCHIVE_DIR);
        File[] archives = archiveDir.listFiles(new LogFileFilter());
        if (archives == null) {
            return;
        }
        for (File f : archives) {
            try {
                FileUtils.moveFileToDirectory((File)f, (File)outDir, (boolean)true);
            }
            catch (IOException exep) {
                LOGGER.error(exep.getMessage(), (Throwable)exep);
            }
        }
    }

    public static byte[] getLogFiles(int numberOfLogFilesNeeded) {
        File[] logFiles;
        int count = 0;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        File archiveDir = new File(ARCHIVE_DIR);
        for (File logFile : logFiles = archiveDir.listFiles(new LogFileFilter())) {
            if (count == numberOfLogFilesNeeded) break;
            ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
            try {
                byte[] data = FileUtils.readFileToByteArray((File)logFile);
                ZipEntry zipEntry = new ZipEntry(logFile.getName());
                zipOutputStream.putNextEntry(zipEntry);
                zipOutputStream.write(data);
                zipOutputStream.closeEntry();
                zipOutputStream.close();
                FileUtils.deleteQuietly((File)logFile);
                ++count;
            }
            catch (IOException ioException) {
                LOGGER.error(ioException.getMessage(), (Throwable)ioException);
            }
        }
        return outputStream.toByteArray();
    }

    private static class LogFileFilter
    implements FilenameFilter {
        private LogFileFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return StringUtils.endsWithIgnoreCase((String)name, (String)".logs.zip");
        }
    }
}

