/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.logging;

import in.gov.uidai.ec.icas.logging._Event;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;

class _Activity
extends _Event {
    protected static final DecimalFormat FORMAT = new DecimalFormat("####0.000");
    protected static final SimpleDateFormat DATEFMT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    protected List<_Event> events;
    protected long endTime;
    protected boolean activeFlag = true;

    public _Activity(Object name, Object ... variables) {
        super(name, variables);
    }

    public void end() {
        this.endTime = System.currentTimeMillis();
        this.activeFlag = false;
    }

    public synchronized void event(Object name, Object ... variables) {
        if (!this.activeFlag) {
            return;
        }
        if (this.events == null) {
            this.events = new LinkedList<_Event>();
        }
        _Event event = new _Event(name, variables);
        event.level = this.level + 1;
        this.events.add(event);
    }

    @Override
    public void log() {
        super.log();
        if (this.events != null) {
            for (_Event event : this.events) {
                event.log();
            }
        }
    }

    @Override
    protected void populateLogString(StringBuilder sb) {
        double interval = (double)(this.endTime - this.startTime) / 1000.0;
        sb.append('[').append(this.getClass().getSimpleName().replace('_', ' ').trim()).append(':').append(FORMAT.format(interval)).append(']').append(this.name);
        if (this.variables != null && this.variables.length > 0) {
            sb.append('(');
            for (int i = 0; i < this.variables.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.variables[i]);
            }
            sb.append(')');
        }
    }
}

