/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class _Event {
    protected static final SimpleDateFormat DATEFMT = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
    protected Object name;
    protected Object[] variables;
    protected long startTime;
    protected Logger logger;
    protected int level;

    public _Event(Object name, Object ... variables) {
        this.name = name;
        this.variables = variables;
        this.startTime = System.currentTimeMillis();
        this.logger = LoggerFactory.getLogger(_Event.class);
    }

    public void log() {
        StringBuilder sb = new StringBuilder();
        sb.append(DATEFMT.format(new Date(this.startTime))).append(' ');
        if (this.level > 1) {
            sb.append(' ').append(' ');
        }
        if (this.level > 0) {
            for (int i = 0; i < this.level; ++i) {
                sb.append(' ');
            }
            sb.append("+-");
        }
        this.populateLogString(sb);
        this.logger.trace(sb.toString());
    }

    protected void populateLogString(StringBuilder sb) {
        sb.append('[').append(this.getClass().getSimpleName().replace('_', ' ').trim()).append(']').append(this.name.toString());
        if (this.variables != null && this.variables.length > 0) {
            sb.append('(');
            for (int i = 0; i < this.variables.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.variables[i]);
            }
            sb.append(')');
        }
    }
}

