/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.preference;

import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.ChecksumInfo;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.EnrolmentInfo;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.LocalisationInfo;
import in.gov.uidai.ec.escapi.PrintAadharInfo;
import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.StationSettingsInfo;
import in.gov.uidai.ec.icas.preference.OucData;
import in.gov.uidai.ec.icas.preference.PreferencesPostProcessor;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

public class OucDataInvocationHandler
implements InvocationHandler {
    private final PreferencesPostProcessor preferencesPostProcessor;
    private final EnrolServiceClientApiService enrolServiceClientApiService;

    public OucDataInvocationHandler(EnrolServiceClientApiService enrolServiceClientApiService, PreferencesPostProcessor preferencesPostProcessor) {
        this.enrolServiceClientApiService = enrolServiceClientApiService;
        this.preferencesPostProcessor = preferencesPostProcessor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mthdName = method.getName();
        if (mthdName.equalsIgnoreCase("toString")) {
            return this.toString();
        }
        if (mthdName.equalsIgnoreCase("hashCode")) {
            return this.hashCode();
        }
        if (mthdName.equalsIgnoreCase("equals")) {
            return false;
        }
        if (mthdName.length() <= 3) {
            return null;
        }
        if (Character.isUpperCase(mthdName.charAt(3))) {
            if (mthdName.startsWith("get")) {
                return this.doGet(method);
            }
            if (mthdName.startsWith("set")) {
                this.doSet(method, args);
            }
        }
        return null;
    }

    private Object doGet(Method method) throws IOException, StationInfoStoreException {
        OucData oucData = method.getAnnotation(OucData.class);
        if (oucData == null) {
            return null;
        }
        Class<?> retype = method.getReturnType();
        if (retype.equals(GpsInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new GpsInfo().getPath());
        }
        if (retype.equals(ScannerInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new ScannerInfo().getPath());
        }
        if (retype.equals(LocalisationInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new LocalisationInfo().getPath());
        }
        if (retype.equals(PrintAadharInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new PrintAadharInfo().getPath());
        }
        if (retype.equals(EnrolmentInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new EnrolmentInfo().getPath());
        }
        if (retype.equals(StationSettingsInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new StationSettingsInfo().getPath());
        }
        if (retype.equals(ChargesInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new ChargesInfo().getPath());
        }
        if (retype.equals(ChecksumInfo.class)) {
            return this.enrolServiceClientApiService.fetchStationInfo(new ChecksumInfo().getPath());
        }
        return null;
    }

    private void doSet(Method method, Object ... args) throws IOException, StationInfoStoreException {
        OucData oucData = method.getAnnotation(OucData.class);
        if (oucData == null) {
            return;
        }
        Class<?> retype = method.getReturnType();
        if (!retype.equals(Void.TYPE)) {
            return;
        }
        if (args == null || args.length != 1 || args[0] == null) {
            return;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Class<?>[] parameterInterfaces = parameterTypes[0].getInterfaces();
        if (parameterInterfaces.length != 0 && parameterInterfaces[0].equals(StationInfo.class)) {
            StationInfo stationInfo = (StationInfo)args[0];
            this.enrolServiceClientApiService.storeStationInfo(stationInfo);
            this.preferencesPostProcessor.save();
        }
    }
}

