/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.preference;

import in.gov.uidai.ec.icas.preference.PreferenceKey;
import in.gov.uidai.ec.icas.preference.TimeInterval;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.configuration.Configuration;

public class PreferenceInvocationHandler
implements InvocationHandler {
    private final Configuration config;

    public PreferenceInvocationHandler(Configuration cfg) {
        this.config = cfg;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mthdName = method.getName();
        if (mthdName.equalsIgnoreCase("toString")) {
            return this.toString();
        }
        if (mthdName.equalsIgnoreCase("hashCode")) {
            return this.hashCode();
        }
        if (mthdName.equalsIgnoreCase("equals")) {
            return false;
        }
        if (mthdName.length() <= 3) {
            return null;
        }
        if (Character.isUpperCase(mthdName.charAt(3))) {
            if (mthdName.startsWith("get")) {
                return this.doGet(method, args);
            }
            if (mthdName.startsWith("set")) {
                this.doSet(method, args);
            }
        }
        return null;
    }

    private Object doGet(Method mthd, Object ... args) {
        PreferenceKey prefKey = mthd.getAnnotation(PreferenceKey.class);
        if (prefKey == null) {
            return null;
        }
        Class<?> retype = mthd.getReturnType();
        if (retype.equals(Void.TYPE)) {
            return null;
        }
        Object defValue = null;
        if (args != null && args.length == 1) {
            defValue = args[0];
        }
        if (retype.equals(Integer.TYPE)) {
            int defValue0 = 0;
            if (defValue != null) {
                if (defValue.getClass().equals(Integer.TYPE)) {
                    defValue0 = (Integer)defValue;
                } else {
                    try {
                        defValue0 = Integer.parseInt(defValue.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return this.config.getInt(prefKey.value(), defValue0);
        }
        if (retype.equals(Long.TYPE)) {
            long defValue0 = 0L;
            if (defValue != null) {
                if (defValue.getClass().equals(Long.TYPE)) {
                    defValue0 = (Long)defValue;
                } else {
                    try {
                        defValue0 = Long.parseLong(defValue.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return this.config.getLong(prefKey.value(), defValue0);
        }
        if (retype.equals(Float.TYPE)) {
            float defValue0 = 0.0f;
            if (defValue != null) {
                if (defValue.getClass().equals(Float.TYPE)) {
                    defValue0 = ((Float)defValue).floatValue();
                } else {
                    try {
                        defValue0 = Float.parseFloat(defValue.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return Float.valueOf(this.config.getFloat(prefKey.value(), defValue0));
        }
        if (retype.equals(Double.TYPE)) {
            double defValue0 = 0.0;
            if (defValue != null) {
                if (defValue.getClass().equals(Double.TYPE)) {
                    defValue0 = (Double)defValue;
                } else {
                    try {
                        defValue0 = Double.parseDouble(defValue.toString());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return this.config.getDouble(prefKey.value(), defValue0);
        }
        if (retype.equals(Boolean.TYPE)) {
            boolean defValue0 = false;
            if (defValue != null) {
                defValue0 = defValue.getClass().equals(Boolean.TYPE) ? (Boolean)defValue : Boolean.parseBoolean(defValue.toString());
            }
            return this.config.getBoolean(prefKey.value(), defValue0);
        }
        if (retype.equals(String.class)) {
            String defValue0 = null;
            if (defValue != null) {
                defValue0 = defValue.toString();
            }
            return this.config.getString(prefKey.value(), defValue0);
        }
        if (retype.equals(String[].class)) {
            return this.config.getStringArray(prefKey.value());
        }
        if (retype.equals(TimeInterval.class)) {
            String defValue0 = null;
            if (defValue != null) {
                defValue0 = defValue.toString();
            }
            String intervalStr = this.config.getString(prefKey.value(), defValue0);
            return new TimeInterval(intervalStr);
        }
        return null;
    }

    private void doSet(Method mthd, Object ... args) {
        PreferenceKey prefKey = mthd.getAnnotation(PreferenceKey.class);
        if (prefKey == null) {
            return;
        }
        Class<?> retype = mthd.getReturnType();
        if (!retype.equals(Void.TYPE)) {
            return;
        }
        if (args == null || args.length != 1 || args[0] == null) {
            return;
        }
        this.config.setProperty(prefKey.value(), args[0]);
    }
}

