/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.preference;

import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.ChecksumInfo;
import in.gov.uidai.ec.escapi.EnrolServiceClientApiService;
import in.gov.uidai.ec.escapi.EnrolmentInfo;
import in.gov.uidai.ec.escapi.FetchRegistrationException;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.LocalisationInfo;
import in.gov.uidai.ec.escapi.PrintAadharInfo;
import in.gov.uidai.ec.escapi.RegistrationInfo;
import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfo;
import in.gov.uidai.ec.escapi.StationInfoStoreException;
import in.gov.uidai.ec.escapi.StationSettingsInfo;
import in.gov.uidai.ec.escapi.StoreRegistrationException;
import in.gov.uidai.ec.icas.preference.IOucDataStore;
import in.gov.uidai.ec.icas.preference.IPreference;
import in.gov.uidai.ec.icas.preference.IPreferenceStore;
import in.gov.uidai.ec.icas.preference.IPreferenceStoreAware;
import in.gov.uidai.ec.icas.preference.OucDataInvocationHandler;
import in.gov.uidai.ec.icas.preference.PreferenceInvocationHandler;
import in.gov.uidai.ec.icas.preference.PreferencesProvider;
import in.gov.uidai.ec.icas.preference.SavedConfigMapper;
import in.gov.uidai.ec.icas.preference.SavedDatFile;
import in.gov.uidai.ec.icas.util.ApplicationVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PreferencesPostProcessor
implements BeanPostProcessor,
InitializingBean,
IPreferenceStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesPostProcessor.class);
    private static final int MIN_METHOD_LEN = 4;
    private static final String ENV_PROPERTIES_RESOURCENAME = "res/icas/prefs/env.properties";
    public static boolean PropertiesLoadError;
    public static String PropertiesLoadErrorDesc;
    private CompositeConfiguration globalConfig;
    private PropertiesConfiguration saveConfig;
    private Resource[] confLocations;
    private PreferenceInvocationHandler prefHandler;
    private OucDataInvocationHandler oucDataHandler;
    private ClassLoader proxyLoader;
    private static boolean stationType;
    private File missingEidLocation;
    @Autowired
    private EnrolServiceClientApiService enrolServiceClientApiService;
    private File savedDatLocation;
    private File disclosedDatLocation;

    public void setLocations(Resource[] locations) {
        Object[] defaultlocations = new Resource[]{new ClassPathResource("res/icas/prefs/cid.properties")};
        this.confLocations = (Resource[])ArrayUtils.addAll((Object[])defaultlocations, (Object[])locations);
    }

    public void setMissingEidLocation(File missingEidLocation) {
        this.missingEidLocation = missingEidLocation;
    }

    public void setDisclosureDatLocation(File disclosedDatLocation) {
        this.disclosedDatLocation = disclosedDatLocation;
    }

    public void setSavedDatLocation(File savedDatLocation) {
        this.savedDatLocation = savedDatLocation;
    }

    private void applyVersionProperties() {
        Object currInternalVersionNumber = this.globalConfig.getProperty("smart.client.internal.version");
        Object currDistributionVersion = this.globalConfig.getProperty("smart.client.distribution");
        boolean isChanged = false;
        if (!ApplicationVersion.INTERNALVERSION.equals(currInternalVersionNumber)) {
            this.globalConfig.setProperty("smart.client.internal.version", (Object)ApplicationVersion.INTERNALVERSION);
            isChanged = true;
        }
        if (!ApplicationVersion.DISTRIBUTION.equals(currDistributionVersion)) {
            this.globalConfig.setProperty("smart.client.distribution", (Object)ApplicationVersion.DISTRIBUTION);
            isChanged = true;
        }
        if (isChanged) {
            this.globalConfig.setProperty("smart.client.message", (Object)"");
            try {
                this.save();
            }
            catch (Exception exep) {
                LOGGER.warn("unable to write saved configuration: {}", (Object)exep.getMessage());
            }
        }
    }

    private void setParameterIfNull(String key, Object val) {
        if (!this.globalConfig.containsKey(key) && val != null) {
            this.globalConfig.setProperty(key, val);
        }
    }

    private void initialiseDefaultParameters() {
        this.setParameterIfNull("ec.location", "Client Location Not Defined");
        this.setParameterIfNull("ec.registered", false);
        this.setParameterIfNull("ec.dereginprogress", "notStarted");
        this.setParameterIfNull("ec.deregistered", false);
        this.setParameterIfNull("ec.deregstarttime", 0L);
    }

    private PropertiesConfiguration initializeEnvironmentSpecificParameters() throws IOException, ConfigurationException {
        String connectType = "wl";
        try {
            connectType = new String(Files.readAllBytes(Paths.get("./conf/connect.type", new String[0])));
            if ("wl".equals(connectType)) {
                stationType = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading connect.type file. Defaulting to connect type 'wl'", (Throwable)e);
        }
        connectType = connectType.replaceAll("\n", "").replaceAll("\r", "").trim();
        ClassPathResource envres = new ClassPathResource(ENV_PROPERTIES_RESOURCENAME);
        PropertiesConfiguration envconfig = new PropertiesConfiguration(envres.getURL());
        String ecmpHostKey = "ecmp_host";
        String ecmpHostKeyConnectType = ecmpHostKey + "_" + connectType;
        String ucHostKey = "uc_host";
        String grpcHostKey = "grpc_host";
        String oauthClientKey = "oauth_clientid";
        String consentOauthClientKey = "consent_oauth_clientid";
        String telemetryLogKey = "telemetry_log";
        String telemetryMetricsKey = "telemetry_metrics";
        if (!envconfig.containsKey(ecmpHostKey) && envconfig.getString(ecmpHostKeyConnectType) != null) {
            envconfig.setProperty(ecmpHostKey, (Object)envconfig.getString(ecmpHostKeyConnectType));
        }
        LOGGER.info(String.format("ecmp_host is %s", envconfig.getProperty(ecmpHostKey)));
        if (envconfig.containsKey(ucHostKey) && envconfig.getString(ucHostKey) != null) {
            envconfig.setProperty(ucHostKey, (Object)envconfig.getString(ucHostKey));
        }
        if (envconfig.containsKey(grpcHostKey) && envconfig.getString(grpcHostKey) != null) {
            envconfig.setProperty(grpcHostKey, (Object)envconfig.getString(grpcHostKey));
        }
        if (envconfig.containsKey(oauthClientKey) && envconfig.getString(oauthClientKey) != null) {
            envconfig.setProperty(oauthClientKey, (Object)envconfig.getString(oauthClientKey));
        }
        if (envconfig.containsKey(consentOauthClientKey) && envconfig.getString(consentOauthClientKey) != null) {
            envconfig.setProperty(consentOauthClientKey, (Object)envconfig.getString(consentOauthClientKey));
        }
        if (envconfig.containsKey(telemetryLogKey) && envconfig.getString(telemetryLogKey) != null) {
            envconfig.setProperty(telemetryLogKey, (Object)envconfig.getString(telemetryLogKey));
        }
        if (envconfig.containsKey(telemetryMetricsKey) && envconfig.getString(telemetryMetricsKey) != null) {
            envconfig.setProperty(telemetryMetricsKey, (Object)envconfig.getString(telemetryMetricsKey));
        }
        LOGGER.info(String.format("uc_host is %s", envconfig.getProperty(ucHostKey)));
        LOGGER.info(String.format("grpc_host is %s", envconfig.getProperty(grpcHostKey)));
        return envconfig;
    }

    public static boolean getStationType() {
        return stationType;
    }

    public void afterPropertiesSet() {
        this.globalConfig = new CompositeConfiguration();
        try {
            PropertiesConfiguration envconfig = this.initializeEnvironmentSpecificParameters();
            this.globalConfig.addConfiguration((Configuration)envconfig);
        }
        catch (Exception e) {
            LOGGER.error("unable to load environment-specific configuration", (Throwable)e);
        }
        if (this.savedDatLocation != null) {
            if (this.savedDatLocation.getParentFile() != null) {
                boolean result = this.savedDatLocation.getParentFile().mkdirs();
                if (result) {
                    LOGGER.info("Directory created");
                } else {
                    LOGGER.info("Directory not created");
                }
            }
            this.saveConfig = this.readSavedConfig();
        }
        try {
            PropertiesConfiguration scannerConfig;
            PropertiesConfiguration gpsConfig;
            PropertiesConfiguration escConfig = this.readEnrolServiceClientConfig(this.saveConfig);
            if (escConfig != null) {
                this.globalConfig.addConfiguration((Configuration)escConfig);
            }
            if ((gpsConfig = this.readGpsConfig(this.saveConfig)) != null) {
                this.globalConfig.addConfiguration((Configuration)gpsConfig);
            }
            if ((scannerConfig = this.readScannerConfig(this.saveConfig)) != null) {
                this.globalConfig.addConfiguration((Configuration)scannerConfig);
            }
            this.writeLocalisationConfigToMemory();
            this.writePrintAadharConfigToMemory();
            this.writeEnrolmentConfigToMemory();
            this.writeStationSettingsConfigToMemory();
            this.writeChargesConfigToMemory();
            this.writeChecksumConfigToMemory();
        }
        catch (StoreRegistrationException e) {
            PropertiesLoadError = true;
            PropertiesLoadErrorDesc = "Unable to store registration info in Aadhaar Enrol Service Client";
            LOGGER.error(PropertiesLoadErrorDesc, (Throwable)e);
        }
        catch (FetchRegistrationException e) {
            PropertiesLoadError = true;
            PropertiesLoadErrorDesc = "Unable to fetch registration info from Aadhaar Enrol Service Client";
            LOGGER.error(PropertiesLoadErrorDesc, (Throwable)e);
        }
        catch (StationInfoStoreException e) {
            PropertiesLoadError = true;
            PropertiesLoadErrorDesc = "Unable to store station info in OUC service";
            LOGGER.error(PropertiesLoadErrorDesc, (Throwable)e);
        }
        catch (IOException e) {
            PropertiesLoadError = true;
            PropertiesLoadErrorDesc = "Aadhaar Enrol Service Client communication error while fetching station details";
            LOGGER.error(PropertiesLoadErrorDesc, (Throwable)e);
        }
        this.globalConfig.addConfiguration((Configuration)this.saveConfig);
        this.save();
        if (this.savedDatLocation != null) {
            this.applyVersionProperties();
        }
        if (ArrayUtils.isEmpty((Object[])this.confLocations)) {
            LOGGER.warn("no preferences location specified");
            return;
        }
        for (Resource loc : this.confLocations) {
            String fileName = loc.getFilename().toLowerCase();
            try {
                PropertiesConfiguration config;
                if (fileName.endsWith(".properties")) {
                    config = new PropertiesConfiguration(loc.getURL());
                    this.globalConfig.addConfiguration((Configuration)config);
                } else if (fileName.endsWith(".xml")) {
                    config = new XMLConfiguration(loc.getURL());
                    this.globalConfig.addConfiguration((Configuration)config);
                }
                LOGGER.debug("configuration from {}", (Object)loc.getURL());
            }
            catch (Exception exep) {
                LOGGER.error("unable to load configuration from " + loc.toString(), (Throwable)exep);
            }
        }
        this.initialiseDefaultParameters();
        this.prefHandler = new PreferenceInvocationHandler((Configuration)this.globalConfig);
        this.oucDataHandler = new OucDataInvocationHandler(this.enrolServiceClientApiService, this);
        this.proxyLoader = Thread.currentThread().getContextClassLoader();
        if (this.proxyLoader == null) {
            this.proxyLoader = this.getClass().getClassLoader();
        }
        LOGGER.debug("configuration loading complete");
    }

    @Override
    public synchronized void save() {
        if (this.saveConfig == null) {
            LOGGER.debug("save configuration not defined");
            return;
        }
        try {
            byte[] inMemoryConfig = this.getInMemoryConfigurationForSave();
            SavedDatFile savedDatFile = new SavedDatFile(this.savedDatLocation.getPath());
            savedDatFile.write(inMemoryConfig);
        }
        catch (Exception e) {
            LOGGER.error("Error writing to saved.dat", (Throwable)e);
        }
    }

    private byte[] getInMemoryConfigurationForSave() throws ConfigurationException, IOException {
        Configuration changes = this.globalConfig.getInMemoryConfiguration();
        Iterator iter = changes.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = changes.getProperty(key);
            this.saveConfig.setProperty(key, value);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.saveConfig.save((OutputStream)baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String name) {
        if (bean instanceof IPreferenceStoreAware) {
            ((IPreferenceStoreAware)bean).setPreferenceStore(this);
        }
        List<Method> prefSet = this.getPreferenceSetters(bean.getClass());
        for (Method method : prefSet) {
            Class<?> type = method.getParameterTypes()[0];
            Object proxy = this.createPreferenceProxy(type);
            try {
                method.invoke(bean, proxy);
                LOGGER.debug("bean:" + name + " injected with proxy {" + type.getName() + "}");
            }
            catch (Exception exep) {
                LOGGER.error("error injecting bean:" + name + " with proxy {" + type.getName() + "}", (Throwable)exep);
            }
        }
        List<Method> oucDataSet = this.getOucDataStoreSetters(bean.getClass());
        for (Method method : oucDataSet) {
            Class<?> type = method.getParameterTypes()[0];
            Object proxy = this.createOucDataStoreProxy(type);
            try {
                method.invoke(bean, proxy);
                LOGGER.debug("bean:" + name + " injected with proxy {" + type.getName() + "}");
            }
            catch (Exception exep) {
                LOGGER.error("error injecting bean:" + name + " with proxy {" + type.getName() + "}", (Throwable)exep);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String name) {
        if (!(bean instanceof PreferencesProvider)) {
            return bean;
        }
        PreferencesProvider provider = (PreferencesProvider)bean;
        List<Configuration> confList = provider.getConfigurations();
        if (confList == null) {
            return bean;
        }
        for (Configuration config : confList) {
            this.globalConfig.addConfiguration(config);
        }
        LOGGER.debug(confList.size() + " configuration added from " + name);
        return bean;
    }

    private List<Method> getPreferenceSetters(Class<?> type) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        if (type == null) {
            return result;
        }
        for (Method method : methods = type.getDeclaredMethods()) {
            Class<?>[] paramTypes = this.getSetters(method);
            if (paramTypes == null || !IPreference.class.isAssignableFrom(paramTypes[0])) continue;
            result.add(method);
        }
        result.addAll(this.getPreferenceSetters(type.getSuperclass()));
        return result;
    }

    private Object createPreferenceProxy(Class<?> type) {
        return Proxy.newProxyInstance(this.proxyLoader, new Class[]{type}, (InvocationHandler)this.prefHandler);
    }

    private List<Method> getOucDataStoreSetters(Class<?> type) {
        Method[] methods;
        ArrayList<Method> result = new ArrayList<Method>();
        if (type == null) {
            return result;
        }
        for (Method method : methods = type.getDeclaredMethods()) {
            Class<?>[] paramTypes = this.getSetters(method);
            if (paramTypes == null || !IOucDataStore.class.isAssignableFrom(paramTypes[0])) continue;
            result.add(method);
        }
        result.addAll(this.getOucDataStoreSetters(type.getSuperclass()));
        return result;
    }

    private Class<?>[] getSetters(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        String mthdName = method.getName();
        if (mthdName.length() < 4) {
            return null;
        }
        if (!mthdName.startsWith("set")) {
            return null;
        }
        if (!method.getReturnType().equals(Void.TYPE)) {
            return null;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length != 1) {
            return null;
        }
        return paramTypes;
    }

    private Object createOucDataStoreProxy(Class<?> type) {
        return Proxy.newProxyInstance(this.proxyLoader, new Class[]{type}, (InvocationHandler)this.oucDataHandler);
    }

    private PropertiesConfiguration readEnrolServiceClientConfig(PropertiesConfiguration saveConfig) throws FetchRegistrationException, IOException {
        RegistrationInfo registrationInfo = this.enrolServiceClientApiService.fetchRegistrationInfo();
        if (registrationInfo == null || registrationInfo.getRegistrationDetails() == null) {
            LOGGER.debug("Registration information not found with Aadhaar Enrol Service Client");
            String registered = (String)saveConfig.getProperty("ec.registered");
            if (StringUtils.isBlank((String)registered) || StringUtils.equalsIgnoreCase((String)registered, (String)"false")) {
                LOGGER.debug("Client not registered for migrating registration details to Aadhaar Enrol Service Client");
                return null;
            }
            LOGGER.info("Migrating registration details to Aadhaar Enrol Service Client");
            this.enrolServiceClientApiService.storeRegistration(SavedConfigMapper.toRegistrationInfo(saveConfig));
            return null;
        }
        return SavedConfigMapper.toRegistrationProperties(registrationInfo);
    }

    private PropertiesConfiguration readGpsConfig(PropertiesConfiguration saveConfig) throws StationInfoStoreException, IOException {
        GpsInfo gpsInfo = new GpsInfo();
        if ((gpsInfo = (GpsInfo)this.enrolServiceClientApiService.fetchStationInfo(gpsInfo.getPath())).isEmpty()) {
            LOGGER.debug("Gps information not found with OUC service.Migrating gps details from saved.dat to OUC service");
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)SavedConfigMapper.toGpsInfo(saveConfig));
            return null;
        }
        return SavedConfigMapper.toGpsProperties(gpsInfo);
    }

    private PropertiesConfiguration readScannerConfig(PropertiesConfiguration saveConfig) throws IOException, StationInfoStoreException {
        ScannerInfo scannerInfo = new ScannerInfo();
        if ((scannerInfo = (ScannerInfo)this.enrolServiceClientApiService.fetchStationInfo(scannerInfo.getPath())).isEmpty()) {
            LOGGER.debug("Scanner details not found with OUC service.Migrating scanner details from saved.dat to OUC service");
            this.enrolServiceClientApiService.storeStationInfo(SavedConfigMapper.toScannerInfo(saveConfig));
            return null;
        }
        return SavedConfigMapper.toScannerProperties(scannerInfo);
    }

    private void writePrintAadharConfigToMemory() throws IOException, StationInfoStoreException {
        PrintAadharInfo printAadharInfo = this.readPrintAadharInfo();
        this.saveConfig.setProperty("ident.eaadhaar.sequence.number", (Object)printAadharInfo.getSequenceNumber());
        LOGGER.info("Printaadhar info migration complete");
    }

    private PrintAadharInfo readPrintAadharInfo() throws IOException, StationInfoStoreException {
        PrintAadharInfo printAadharInfo = new PrintAadharInfo();
        LOGGER.info("Fetching printaadhar info from OUC...");
        StationInfo stationInfo = this.enrolServiceClientApiService.fetchStationInfo(printAadharInfo.getPath());
        printAadharInfo = (PrintAadharInfo)stationInfo;
        if (printAadharInfo.isEmpty()) {
            LOGGER.debug("PrintAadhar details not found with Enrol Service Client!!!");
            printAadharInfo = SavedConfigMapper.toPrintAadharInfo(this.saveConfig);
            LOGGER.info("Writing printaadhar info to OUC...");
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)printAadharInfo);
        }
        return printAadharInfo;
    }

    private void writeChecksumConfigToMemory() throws IOException, StationInfoStoreException {
        ChecksumInfo checksumInfo = this.readChecksumInfo();
        this.saveConfig.setProperty("smart.lvs.checkSum", (Object)checksumInfo.getLvsChecksum());
        this.saveConfig.setProperty("smart.client.sync.new.checkSum", (Object)checksumInfo.getSyncNewChecksum());
    }

    private ChecksumInfo readChecksumInfo() throws IOException, StationInfoStoreException {
        ChecksumInfo checksumInfo = new ChecksumInfo();
        if ((checksumInfo = (ChecksumInfo)this.enrolServiceClientApiService.fetchStationInfo(checksumInfo.getPath())).isEmpty()) {
            LOGGER.debug("Checksum details not found with Enrol Service Client");
            checksumInfo = SavedConfigMapper.toChecksumInfo(this.saveConfig);
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)checksumInfo);
        }
        return checksumInfo;
    }

    private void writeLocalisationConfigToMemory() throws IOException, StationInfoStoreException {
        LocalisationInfo localisationInfo = this.readLocalisationInfo();
        this.saveConfig.setProperty("application.localize", (Object)localisationInfo.getLocalise());
        this.saveConfig.setProperty("application.tlit.locale", (Object)localisationInfo.getLocale());
    }

    private LocalisationInfo readLocalisationInfo() throws IOException, StationInfoStoreException {
        LocalisationInfo localisationInfo = new LocalisationInfo();
        if ((localisationInfo = (LocalisationInfo)this.enrolServiceClientApiService.fetchStationInfo(localisationInfo.getPath())).isEmpty()) {
            LOGGER.debug("Localisation details not found with Enrol Service Client");
            localisationInfo = SavedConfigMapper.toLocalisationInfo(this.saveConfig);
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)localisationInfo);
        }
        return localisationInfo;
    }

    private void writeEnrolmentConfigToMemory() throws IOException, StationInfoStoreException {
        EnrolmentInfo enrolmentInfo = this.readEnrolmentInfo();
        this.saveConfig.setProperty("ident.sequence.number", (Object)enrolmentInfo.getSequenceNumber());
        LOGGER.info("Migration of enrolment info complete");
    }

    private EnrolmentInfo readEnrolmentInfo() throws IOException, StationInfoStoreException {
        EnrolmentInfo enrolmentInfo = new EnrolmentInfo();
        if ((enrolmentInfo = (EnrolmentInfo)this.enrolServiceClientApiService.fetchStationInfo(enrolmentInfo.getPath())).isEmpty()) {
            LOGGER.info("Enrolment details not found with Enrol Service Client");
            enrolmentInfo = SavedConfigMapper.toEnrolmentInfo(this.saveConfig);
            LOGGER.info("Migrating enrolment info to Enrol Service Client");
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)enrolmentInfo);
        }
        return enrolmentInfo;
    }

    private void writeStationSettingsConfigToMemory() throws IOException, StationInfoStoreException {
        StationSettingsInfo stationSettingsInfo = this.readStationSettingsInfo();
        this.saveConfig.setProperty("smart.client.allowFullBe", (Object)stationSettingsInfo.isFullBiometricExceptionAllowed());
        this.saveConfig.setProperty("smart.client.max.unuploaded.packets", (Object)stationSettingsInfo.getMaxUnuploadedPackets());
        this.saveConfig.setProperty("smart.client.fingerIris.authType", (Object)stationSettingsInfo.getFingerIrisAuthType());
        this.saveConfig.setProperty("smart.client.max.packets.per.day", (Object)stationSettingsInfo.getMaxPacketsPerDay());
        this.saveConfig.setProperty("smart.client.fingerIris.authType.osi", (Object)stationSettingsInfo.getFingerIrisAuthTypeOsi());
        this.saveConfig.setProperty("smart.client.gps.capture.interval.offline", (Object)stationSettingsInfo.getGpsCaptureIntervalOffline());
        this.saveConfig.setProperty("smart.client.gps.update.verify", (Object)stationSettingsInfo.getGpsUpdateVerify());
        this.saveConfig.setProperty("smart.client.blacklisted.operator.ids", (Object)stationSettingsInfo.getBlacklistedOperatorIds());
    }

    private StationSettingsInfo readStationSettingsInfo() throws IOException, StationInfoStoreException {
        StationSettingsInfo stationSettingsInfo = new StationSettingsInfo();
        if ((stationSettingsInfo = (StationSettingsInfo)this.enrolServiceClientApiService.fetchStationInfo(stationSettingsInfo.getPath())).isEmpty()) {
            LOGGER.debug("Station Settings details not found with Enrol Service Client");
            stationSettingsInfo = (StationSettingsInfo)SavedConfigMapper.toStationSettingsInfo(this.saveConfig);
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)stationSettingsInfo);
        }
        return stationSettingsInfo;
    }

    private void writeChargesConfigToMemory() throws IOException, StationInfoStoreException {
        LOGGER.info("Starting migration of charges information...");
        ChargesInfo chargesInfo = this.readChargesInfo();
        this.saveConfig.setProperty("gst.applied", (Object)Float.valueOf(chargesInfo.getGstApplied()));
        this.saveConfig.setProperty("registrar.configuration.for.payment.receipt", (Object)chargesInfo.getRegistrarConfigurationsForPaymentReceipt());
        this.saveConfig.setProperty("amount.charged.for.new.enrolment", (Object)Float.valueOf(chargesInfo.getAmountChargedForNewEnrolment()));
        this.saveConfig.setProperty("amount.charged.for.demo.update", (Object)Float.valueOf(chargesInfo.getAmountChargedForDemographicUpdate()));
        this.saveConfig.setProperty("amount.charged.for.bio.update", (Object)Float.valueOf(chargesInfo.getAmountChargedForBiometricUpdate()));
        this.saveConfig.setProperty("amount.charged.for.doc.update", (Object)Float.valueOf(chargesInfo.getAmountChargedForDemographicUpdate()));
        LOGGER.info("Migration of enrolment info complete.");
    }

    private ChargesInfo readChargesInfo() throws IOException, StationInfoStoreException {
        ChargesInfo chargesInfo = new ChargesInfo();
        chargesInfo = (ChargesInfo)this.enrolServiceClientApiService.fetchStationInfo(chargesInfo.getPath());
        if ((chargesInfo = (ChargesInfo)this.enrolServiceClientApiService.fetchStationInfo(chargesInfo.getPath())).isAnyInformationUnavailable()) {
            LOGGER.info("Some or many of the charges information not found with Enrol Service Client");
            chargesInfo = SavedConfigMapper.toChargesInfo(this.saveConfig);
            LOGGER.info("Migrating charges info to Enrol Service Client");
            this.enrolServiceClientApiService.storeStationInfo((StationInfo)chargesInfo);
            LOGGER.info("Migrated charges info to Enrol Service Client");
        }
        return chargesInfo;
    }

    private PropertiesConfiguration readSavedConfig() {
        PropertiesConfiguration newSaveConfig = new PropertiesConfiguration();
        Properties dedupeConfig = new Properties();
        try {
            SavedDatFile savedDatFile = new SavedDatFile(this.savedDatLocation.getPath());
            byte[] buf = savedDatFile.readWithRecover();
            if (buf != null) {
                dedupeConfig.load(new ByteArrayInputStream(buf));
            } else {
                LOGGER.warn("unable to read saved configuration");
            }
            Enumeration<?> keys = dedupeConfig.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = dedupeConfig.getProperty(key);
                newSaveConfig.setProperty(key, (Object)value);
                this.setEncodedRegEaProps(newSaveConfig, key, value);
            }
        }
        catch (Exception e) {
            LOGGER.warn("unable to read and decrypt saved configuration: {}", (Object)e.getMessage());
        }
        return newSaveConfig;
    }

    private void setEncodedRegEaProps(PropertiesConfiguration newSaveConfig, String key, Object val) {
        String value;
        if (key.equalsIgnoreCase("ident.registrar.name")) {
            String regEncodedKey = "ident.registrar.name.encoded";
            value = (String)val;
            if (StringUtils.isNotBlank((String)value)) {
                newSaveConfig.setProperty(regEncodedKey, (Object)new String(Base64.getEncoder().encode(value.getBytes())));
            } else {
                newSaveConfig.setProperty(regEncodedKey, (Object)"");
            }
        }
        if (key.equalsIgnoreCase("ident.agency.name")) {
            String eaEncodedKey = "ident.agency.name.encoded";
            value = (String)val;
            if (StringUtils.isNotBlank((String)value)) {
                newSaveConfig.setProperty(eaEncodedKey, (Object)new String(Base64.getEncoder().encode(value.getBytes())));
            } else {
                newSaveConfig.setProperty(eaEncodedKey, (Object)"");
            }
        }
    }

    static {
        stationType = false;
    }
}

