/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.preference;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class PreferencesProvider
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesProvider.class);
    private Resource[] confLocations;
    private List<Configuration> confList;

    public void setLocations(Resource[] locations) {
        this.confLocations = locations;
    }

    public void afterPropertiesSet() {
        this.confList = new ArrayList<Configuration>();
        if (ArrayUtils.isEmpty((Object[])this.confLocations)) {
            LOGGER.warn("no preferences location specified");
            return;
        }
        for (Resource loc : this.confLocations) {
            String fileName = loc.getFilename().toLowerCase();
            try {
                PropertiesConfiguration config;
                if (fileName.endsWith(".properties")) {
                    config = new PropertiesConfiguration(loc.getURL());
                    this.confList.add((Configuration)config);
                    LOGGER.debug("properties configuration from " + loc.getURL());
                }
                if (!fileName.endsWith(".xml")) continue;
                config = new XMLConfiguration(loc.getURL());
                this.confList.add((Configuration)config);
                LOGGER.debug("xml configuration from " + loc.getURL());
            }
            catch (Exception exep) {
                LOGGER.error("unable to load configuration from " + loc.toString(), (Throwable)exep);
            }
        }
        LOGGER.debug("configuration loading complete");
    }

    List<Configuration> getConfigurations() {
        return this.confList;
    }
}

