/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.preference;

import in.gov.uidai.ec.escapi.ChargesInfo;
import in.gov.uidai.ec.escapi.ChecksumInfo;
import in.gov.uidai.ec.escapi.EnrolmentInfo;
import in.gov.uidai.ec.escapi.GpsInfo;
import in.gov.uidai.ec.escapi.LocalisationInfo;
import in.gov.uidai.ec.escapi.PrintAadharInfo;
import in.gov.uidai.ec.escapi.RegistrationInfo;
import in.gov.uidai.ec.escapi.ScannerInfo;
import in.gov.uidai.ec.escapi.StationInfo;
import in.gov.uidai.ec.escapi.StationSettingsInfo;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;

class SavedConfigMapper {
    static String RFC_3339_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";

    SavedConfigMapper() {
    }

    static RegistrationInfo toRegistrationInfo(PropertiesConfiguration saveConfig) {
        RegistrationInfo.Id id = new RegistrationInfo.Id();
        id.setRegistrarId((String)saveConfig.getProperty("ident.registrar.id"));
        id.setAgencyId((String)saveConfig.getProperty("ident.agency.id"));
        id.setStationId((String)saveConfig.getProperty("ident.station.id"));
        RegistrationInfo.MachineCodeDetails machineCodeDetails = new RegistrationInfo.MachineCodeDetails();
        machineCodeDetails.setRegisteredValue((String)saveConfig.getProperty("ident.machine.code"));
        machineCodeDetails.setOem((String)saveConfig.getProperty("ident.machine.oem"));
        machineCodeDetails.setPrimaryMachineHash((String)saveConfig.getProperty("ident.machine.primary"));
        machineCodeDetails.setSecondaryMachineHash((String)saveConfig.getProperty("ident.machine.secondary"));
        machineCodeDetails.setMachineDetails((String)saveConfig.getProperty("ident.machine.details"));
        machineCodeDetails.setRegisteredMode((String)saveConfig.getProperty("ident.machine.registered.mode"));
        RegistrationInfo.RegistrationStatusDetails registrationStatusDetails = new RegistrationInfo.RegistrationStatusDetails();
        String deRegInProgress = (String)saveConfig.getProperty("ec.dereginprogress");
        if (StringUtils.isNotBlank((String)deRegInProgress) && (StringUtils.equalsIgnoreCase((String)deRegInProgress, (String)"inProgress") || StringUtils.equalsIgnoreCase((String)deRegInProgress, (String)"completed"))) {
            registrationStatusDetails.setDeRegistrationInProgress(true);
            String deRegStartTime = (String)saveConfig.getProperty("ec.deregstarttime");
            long deRegStTime = StringUtils.isNotBlank((String)deRegStartTime) ? Long.parseLong(deRegStartTime) : 0L;
            String deRegStTimeString = deRegStTime == 0L ? "" : new SimpleDateFormat(RFC_3339_FORMAT).format(new Date(deRegStTime));
            registrationStatusDetails.setDeRegistrationStartTime(deRegStTimeString);
        }
        RegistrationInfo.RegistrationDetails registrationDetails = new RegistrationInfo.RegistrationDetails();
        registrationDetails.setRegistrarName(SavedConfigMapper.getDecodedProperty(saveConfig, "ident.registrar.name"));
        registrationDetails.setAgencyName(SavedConfigMapper.getDecodedProperty(saveConfig, "ident.agency.name"));
        registrationDetails.setTimeStamp((String)saveConfig.getProperty("ec.regTime"));
        registrationDetails.setId(id);
        registrationDetails.setMachineCodeDetails(machineCodeDetails);
        RegistrationInfo registrationInfo = new RegistrationInfo();
        registrationInfo.setRegistrationDetails(registrationDetails);
        registrationInfo.setRegistrationStatusDetails(registrationStatusDetails);
        return registrationInfo;
    }

    static PropertiesConfiguration toRegistrationProperties(RegistrationInfo registrationInfo) {
        PropertiesConfiguration regProperties = new PropertiesConfiguration();
        regProperties.setProperty("ident.registrar.id", (Object)registrationInfo.getRegistrationDetails().getId().getRegistrarId());
        regProperties.setProperty("ident.registrar.name", (Object)registrationInfo.getRegistrationDetails().getRegistrarName());
        regProperties.setProperty("ident.agency.id", (Object)registrationInfo.getRegistrationDetails().getId().getAgencyId());
        regProperties.setProperty("ident.agency.name", (Object)registrationInfo.getRegistrationDetails().getAgencyName());
        regProperties.setProperty("ident.station.id", (Object)registrationInfo.getRegistrationDetails().getId().getStationId());
        regProperties.setProperty("ec.regTime", (Object)registrationInfo.getRegistrationDetails().getTimeStamp());
        RegistrationInfo.RegistrationStatusDetails registrationStatusDetails = registrationInfo.getRegistrationStatusDetails();
        if (registrationStatusDetails != null && registrationStatusDetails.isDeRegistrationInProgress()) {
            regProperties.setProperty("ec.dereginprogress", (Object)"inProgress");
        } else {
            regProperties.setProperty("ec.dereginprogress", (Object)"notStarted");
        }
        regProperties.setProperty("ident.machine.code", (Object)registrationInfo.getRegistrationDetails().getMachineCodeDetails().getRegisteredValue());
        regProperties.setProperty("ident.machine.oem", (Object)registrationInfo.getRegistrationDetails().getMachineCodeDetails().getOem());
        regProperties.setProperty("ident.machine.primary", (Object)registrationInfo.getRegistrationDetails().getMachineCodeDetails().getPrimaryMachineHash());
        regProperties.setProperty("ident.machine.secondary", (Object)registrationInfo.getRegistrationDetails().getMachineCodeDetails().getSecondaryMachineHash());
        regProperties.setProperty("ident.machine.details", (Object)registrationInfo.getRegistrationDetails().getMachineCodeDetails().getMachineDetails());
        regProperties.setProperty("ident.machine.registered.mode", (Object)registrationInfo.getRegistrationDetails().getMachineCodeDetails().getRegisteredMode());
        return regProperties;
    }

    static String getDecodedProperty(PropertiesConfiguration saveConfig, String key) {
        if (key.equalsIgnoreCase("ident.registrar.name")) {
            String encodedRegName = saveConfig.getString("ident.registrar.name.encoded");
            String regName = new String(Base64.getDecoder().decode(encodedRegName));
            if (StringUtils.isNotBlank((String)regName)) {
                return regName;
            }
        }
        if (key.equalsIgnoreCase("ident.agency.name")) {
            String encodedAgencyName = saveConfig.getString("ident.agency.name.encoded");
            String agencyName = new String(Base64.getDecoder().decode(encodedAgencyName));
            if (StringUtils.isNotBlank((String)agencyName)) {
                return agencyName;
            }
        }
        return "";
    }

    static GpsInfo toGpsInfo(PropertiesConfiguration saveConfig) {
        GpsInfo gpsInfo = new GpsInfo();
        String latitude = (String)saveConfig.getProperty("gps.latitude");
        String longitude = (String)saveConfig.getProperty("gps.altitude");
        String altitude = (String)saveConfig.getProperty("gps.longitude");
        String speed = (String)saveConfig.getProperty("gps.speed");
        String captureTime = (String)saveConfig.getProperty("gps.captureTime");
        gpsInfo.setLatitude(Float.valueOf(StringUtils.isEmpty((String)latitude) ? 0.0f : Float.parseFloat(latitude)));
        gpsInfo.setAltitude(Float.valueOf(StringUtils.isEmpty((String)longitude) ? 0.0f : Float.parseFloat(longitude)));
        gpsInfo.setSpeed(StringUtils.isEmpty((String)speed) ? 0 : Integer.parseInt(speed));
        gpsInfo.setLongitude(Float.valueOf(StringUtils.isEmpty((String)altitude) ? 0.0f : Float.parseFloat(altitude)));
        gpsInfo.setCaptureTime(Long.valueOf(StringUtils.isEmpty((String)captureTime) ? 0L : Long.parseLong(captureTime)));
        return gpsInfo;
    }

    static PropertiesConfiguration toGpsProperties(GpsInfo gpsInfo) {
        PropertiesConfiguration gpsProperties = new PropertiesConfiguration();
        gpsProperties.setProperty("gps.latitude", (Object)gpsInfo.getLatitude());
        gpsProperties.setProperty("gps.altitude", (Object)gpsInfo.getAltitude());
        gpsProperties.setProperty("gps.speed", (Object)gpsInfo.getSpeed());
        gpsProperties.setProperty("gps.longitude", (Object)gpsInfo.getLongitude());
        gpsProperties.setProperty("gps.captureTime", (Object)gpsInfo.getCaptureTime());
        return gpsProperties;
    }

    public static StationInfo toScannerInfo(PropertiesConfiguration saveConfig) {
        ScannerInfo scannerInfo = new ScannerInfo();
        scannerInfo.setLastScanner((String)saveConfig.getProperty("scanner.lastScanner"));
        scannerInfo.setLastMode((String)saveConfig.getProperty("scanner.lastMode"));
        return scannerInfo;
    }

    public static LocalisationInfo toLocalisationInfo(PropertiesConfiguration saveConfig) {
        LocalisationInfo localisationInfo = new LocalisationInfo();
        boolean localise = saveConfig.containsKey("application.localize") && Boolean.parseBoolean((String)saveConfig.getProperty("application.localize"));
        String locale = saveConfig.containsKey("application.tlit.locale") ? (String)saveConfig.getProperty("application.tlit.locale") : "hi_in";
        localisationInfo.setLocalise(localise);
        localisationInfo.setLocale(locale);
        return localisationInfo;
    }

    public static PrintAadharInfo toPrintAadharInfo(PropertiesConfiguration saveConfig) {
        PrintAadharInfo printAadharInfo = new PrintAadharInfo();
        String sequenceNumber = saveConfig.containsKey("ident.eaadhaar.sequence.number") ? (String)saveConfig.getProperty("ident.eaadhaar.sequence.number") : "00000";
        printAadharInfo.setSequenceNumber(sequenceNumber);
        return printAadharInfo;
    }

    public static EnrolmentInfo toEnrolmentInfo(PropertiesConfiguration saveConfig) {
        EnrolmentInfo enrolmentInfo = new EnrolmentInfo();
        String sequenceNumber = saveConfig.containsKey("ident.sequence.number") ? (String)saveConfig.getProperty("ident.sequence.number") : "00000";
        enrolmentInfo.setSequenceNumber(sequenceNumber);
        return enrolmentInfo;
    }

    public static ChargesInfo toChargesInfo(PropertiesConfiguration saveConfig) {
        ChargesInfo chargesInfo = new ChargesInfo();
        float gstApplied = saveConfig.containsKey("gst.applied") ? Float.parseFloat((String)saveConfig.getProperty("gst.applied")) : 18.0f;
        String[] registrarConfirmationForPaymentReceipt = saveConfig.containsKey("registrar.configuration.for.payment.receipt") ? saveConfig.getStringArray("registrar.configuration.for.payment.receipt") : new String[]{};
        float amountChargedForNewEnrolment = saveConfig.containsKey("amount.charged.for.new.enrolment") ? Float.parseFloat((String)saveConfig.getProperty("amount.charged.for.new.enrolment")) : 0.0f;
        float amountChargedForDemographicUpdate = saveConfig.containsKey("amount.charged.for.demo.update") ? Float.parseFloat((String)saveConfig.getProperty("amount.charged.for.demo.update")) : 63.56f;
        float amountChargedForBiometricUpdate = saveConfig.containsKey("amount.charged.for.bio.update") ? Float.parseFloat((String)saveConfig.getProperty("amount.charged.for.bio.update")) : 105.93f;
        float amountChargedForDocumentUpdate = saveConfig.containsKey("amount.charged.for.demo.update") ? Float.parseFloat((String)saveConfig.getProperty("amount.charged.for.demo.update")) : 63.56f;
        chargesInfo.setGstApplied(gstApplied);
        chargesInfo.setRegistrarConfigurationsForPaymentReceipt(registrarConfirmationForPaymentReceipt);
        chargesInfo.setAmountChargedForNewEnrolment(amountChargedForNewEnrolment);
        chargesInfo.setAmountChargedForDemographicUpdate(amountChargedForDemographicUpdate);
        chargesInfo.setAmountChargedForBiometricUpdate(amountChargedForBiometricUpdate);
        chargesInfo.setAmountChargedForDemographicUpdate(amountChargedForDocumentUpdate);
        return chargesInfo;
    }

    public static ChecksumInfo toChecksumInfo(PropertiesConfiguration saveConfig) {
        ChecksumInfo checksumInfo = new ChecksumInfo();
        checksumInfo.setLvsChecksum((String)saveConfig.getProperty("smart.lvs.checkSum"));
        checksumInfo.setSyncNewChecksum((String)saveConfig.getProperty("smart.client.sync.new.checkSum"));
        return checksumInfo;
    }

    public static PropertiesConfiguration toScannerProperties(ScannerInfo scannerInfo) {
        PropertiesConfiguration scannerProperties = new PropertiesConfiguration();
        scannerProperties.setProperty("scanner.lastScanner", (Object)scannerInfo.getLastScanner());
        scannerProperties.setProperty("scanner.lastMode", (Object)scannerInfo.getLastMode());
        return scannerProperties;
    }

    public static StationInfo toStationSettingsInfo(PropertiesConfiguration saveConfig) {
        StationSettingsInfo stationSettingsInfo = new StationSettingsInfo();
        boolean isFullBEAllowed = saveConfig.containsKey("smart.client.allowFullBe") && Boolean.parseBoolean((String)saveConfig.getProperty("smart.client.allowFullBe"));
        String maxUnuploadedPackets = (String)saveConfig.getProperty("smart.client.max.unuploaded.packets");
        String fingerIrisAuthType = (String)saveConfig.getProperty("smart.client.fingerIris.authType");
        String maxPacketsPerDay = (String)saveConfig.getProperty("smart.client.max.packets.per.day");
        String fingerIrisAuthTypeForOsi = (String)saveConfig.getProperty("smart.client.fingerIris.authType.osi");
        String gpsCaptureIntervalOffline = (String)saveConfig.getProperty("smart.client.gps.capture.interval.offline");
        String gpsUpdateVerify = (String)saveConfig.getProperty("smart.client.gps.update.verify");
        String blacklistedOperatorIdString = (String)saveConfig.getProperty("smart.client.blacklisted.operator.ids");
        String[] blacklistedOperatorIds = new String[]{};
        if (!StringUtils.isEmpty((String)blacklistedOperatorIdString)) {
            blacklistedOperatorIds = blacklistedOperatorIdString.split(",");
        }
        stationSettingsInfo.setFullBiometricExceptionAllowed(isFullBEAllowed);
        stationSettingsInfo.setFingerIrisAuthType(fingerIrisAuthType);
        stationSettingsInfo.setFingerIrisAuthTypeOsi(fingerIrisAuthTypeForOsi);
        stationSettingsInfo.setMaxUnuploadedPackets(StringUtils.isEmpty((String)maxUnuploadedPackets) ? 0 : Integer.parseInt(maxUnuploadedPackets));
        stationSettingsInfo.setMaxPacketsPerDay(StringUtils.isEmpty((String)maxPacketsPerDay) ? 0 : Integer.parseInt(maxPacketsPerDay));
        stationSettingsInfo.setGpsCaptureIntervalOffline(gpsCaptureIntervalOffline);
        stationSettingsInfo.setGpsUpdateVerify(gpsUpdateVerify);
        stationSettingsInfo.setBlacklistedOperatorIds(blacklistedOperatorIds);
        return stationSettingsInfo;
    }
}

