/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.scan;

import SK.gnome.morena.Morena;
import SK.gnome.morena.MorenaException;
import SK.gnome.morena.MorenaImage;
import SK.gnome.morena.MorenaSource;
import SK.gnome.sane.SaneConnection;
import SK.gnome.sane.SaneException;
import SK.gnome.sane.SaneSource;
import in.gov.uidai.ec.icas.error.ClientException;
import in.gov.uidai.ec.icas.scan.IDocScan;
import in.gov.uidai.ec.icas.scan.ScannerProp;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorenaSaneScan
implements IDocScan {
    private static final Logger LOGGER = LoggerFactory.getLogger(MorenaSaneScan.class);
    private MorenaSource source;
    private SaneConnection saneConn;

    @Override
    public String[] getDeviceList() {
        HashSet<String> deviceList = new HashSet<String>();
        try {
            SaneSource[] sourceList;
            this.saneConn = this.getSaneConn();
            for (SaneSource source : sourceList = this.saneConn.listSources()) {
                LOGGER.debug("Source = [" + source.getName() + "]");
                deviceList.add(source.getModel());
            }
        }
        catch (SaneException | IOException e) {
            throw new ClientException("Error while getting device list", e);
        }
        return deviceList.toArray(new String[0]);
    }

    @Override
    public BufferedImage acquireImage() {
        try {
            MorenaImage image = new MorenaImage((ImageProducer)this.source);
            if (image.getStatus() == 4) {
                throw new ClientException("Document scan cancelled");
            }
            Image awtImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)image);
            BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            bi.createGraphics().drawImage(awtImage, 0, 0, null);
            return bi;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to acquire image", (Throwable)e);
            throw new ClientException("Unable to acquire image.", e);
        }
    }

    @Override
    public void acquireImage(String fileName) {
        try {
            MorenaImage image = new MorenaImage((ImageProducer)this.source);
            if (image.getStatus() == 4) {
                throw new ClientException("Document scan cancelled");
            }
            Image awtImage = Toolkit.getDefaultToolkit().createImage((ImageProducer)image);
            BufferedImage bi = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            bi.createGraphics().drawImage(awtImage, 0, 0, null);
            File tempImage = new File("tempFile.jpg");
            ImageIO.write((RenderedImage)bi, "jpg", tempImage);
            long imageSize = tempImage.length() / 1024L;
            LOGGER.debug("Image size before: " + imageSize);
            Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpg");
            ImageWriter writer = iter.next();
            String fname = fileName + ".jpg";
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(fname));
            writer.setOutput(ios);
            JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
            iwparam.setCompressionMode(2);
            if (imageSize > 300L) {
                iwparam.setCompressionQuality(0.1f);
            }
            writer.write(null, new IIOImage(bi, null, null), iwparam);
            ios.flush();
            writer.dispose();
            ios.close();
            LOGGER.debug("Size of acquired image is " + image.getWidth() + " x " + image.getHeight() + " x " + image.getPixelSize());
            boolean res = tempImage.delete();
            if (res) {
                LOGGER.info("File deleted");
            } else {
                LOGGER.info("File not deleted");
            }
        }
        catch (Exception e) {
            LOGGER.debug("Unable to acquire image", (Throwable)e);
            throw new ClientException("Unable to acquire image.", e);
        }
    }

    @Override
    public void setSource(String sourceName) {
        try {
            this.saneConn = this.getSaneConn();
            for (SaneSource source : this.saneConn.listSources()) {
                if (!source.getModel().equals(sourceName)) continue;
                this.source = source;
                this.setSourceProperties();
            }
        }
        catch (Exception e) {
            throw new ClientException("Error while setting source", e);
        }
    }

    @Override
    public void showUI(boolean uiFlag) {
        this.source.setVisible(uiFlag);
    }

    @Override
    public void setProperties(ScannerProp scanProp) {
        try {
            switch (scanProp.getMode()) {
                case COLOR: {
                    this.source.setColorMode();
                    break;
                }
                case BLACK: {
                    this.source.setGrayScaleMode();
                }
            }
            this.source.setResolution((double)scanProp.getDpi());
        }
        catch (MorenaException e) {
            throw new ClientException("Error setting scanner properties", e);
        }
    }

    @Override
    public void close() {
        try {
            Morena.close();
        }
        catch (MorenaException e) {
            LOGGER.debug("Error while closing morena resources", (Throwable)e);
        }
    }

    private synchronized void setSourceProperties() {
        try {
            this.source.maskUnsupportedCapabilityException(true);
            this.source.maskBadValueException(true);
            this.source.setVisible(false);
        }
        catch (Exception e) {
            throw new ClientException("Error while setting properties", e);
        }
    }

    private SaneConnection getSaneConn() throws SaneException, IOException {
        if (this.saneConn != null) {
            try {
                this.saneConn.close();
            }
            catch (Exception e) {
                LOGGER.debug("Error while closing sane connection", (Throwable)e);
            }
        }
        return SaneConnection.connect((String)"localhost");
    }
}

