/*
 * Decompiled with CFR 0.152.
 */
package in.gov.uidai.ec.icas.scan;

import in.gov.uidai.ec.icas.scan.IDocScan;
import in.gov.uidai.ec.icas.scan.MorenaSaneScan;
import in.gov.uidai.ec.icas.scan.MorenaTwainScan;
import in.gov.uidai.ec.icas.scan.ScannerProp;
import java.awt.image.BufferedImage;

public class MorenaScan
implements IDocScan {
    private IDocScan morenaScan;

    public MorenaScan() {
        if (this.isWindows()) {
            this.morenaScan = new MorenaTwainScan();
        } else if (this.isUnix()) {
            this.morenaScan = new MorenaSaneScan();
        }
    }

    @Override
    public String[] getDeviceList() {
        return this.morenaScan.getDeviceList();
    }

    @Override
    public void acquireImage(String fileName) {
        this.morenaScan.acquireImage(fileName);
    }

    @Override
    public BufferedImage acquireImage() {
        return this.morenaScan.acquireImage();
    }

    @Override
    public void setSource(String sourceName) {
        this.morenaScan.setSource(sourceName);
    }

    @Override
    public void showUI(boolean uiFlag) {
        this.morenaScan.showUI(uiFlag);
    }

    @Override
    public void setProperties(ScannerProp scanProp) {
        this.morenaScan.setProperties(scanProp);
    }

    @Override
    public void close() {
        this.morenaScan.close();
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("win");
    }

    private boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("nix") || os.contains("nux");
    }
}

